/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.deop.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.deop.DeopModule;
import net.flectone.pulse.module.message.deop.extractor.DeopExtractor;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class DeopPulseListener
implements PulseListener {
    private final DeopModule deopModule;
    private final DeopExtractor deopExtractor;

    @Inject
    public DeopPulseListener(DeopModule deopModule, DeopExtractor deopExtractor) {
        this.deopModule = deopModule;
        this.deopExtractor = deopExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        if (event.getTranslationKey() != MinecraftTranslationKey.COMMANDS_DEOP_SUCCESS) {
            return;
        }
        Optional<String> target = this.deopExtractor.extract(event);
        if (target.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.deopModule.send(event.getFPlayer(), target.get());
    }
}

