/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.enchant;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.enchant.listener.EnchantPulseListener;
import net.flectone.pulse.module.message.enchant.model.Enchant;
import net.flectone.pulse.module.message.enchant.model.EnchantMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class EnchantModule
extends AbstractModuleLocalization<Localization.Message.Enchant> {
    private final Message.Enchant message;
    private final Permission.Message.Enchant permission;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public EnchantModule(FileResolver fileResolver, FPlayerService fPlayerService, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getEnchant(), MessageType.ENCHANT);
        this.message = fileResolver.getMessage().getEnchant();
        this.permission = fileResolver.getPermission().getMessage().getEnchant();
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(EnchantPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey key, Enchant enchant) {
        boolean isSingle;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = fPlayer;
        boolean bl = isSingle = key == MinecraftTranslationKey.COMMANDS_ENCHANT_SUCCESS_SINGLE || key == MinecraftTranslationKey.COMMANDS_ENCHANT_SUCCESS;
        if (isSingle && !enchant.value().isEmpty() && (fTarget = this.fPlayerService.getFPlayer(enchant.value())).isUnknown()) {
            return;
        }
        this.sendMessage(((EnchantMetadata.EnchantMetadataBuilder)((EnchantMetadata.EnchantMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EnchantMetadata.EnchantMetadataBuilder)((EnchantMetadata.EnchantMetadataBuilder)((EnchantMetadata.EnchantMetadataBuilder)EnchantMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(s -> StringUtils.replaceEach((String)(isSingle ? s.getSingle() : s.getMultiple()), (String[])new String[]{"<count>", "<enchant>", "<level>"}, (String[])new String[]{enchant.value(), enchant.name(), enchant.level()}))).enchant(enchant)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

