/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.enchant.extractor;

import java.util.Optional;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.enchant.model.Enchant;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;

@Singleton
public class EnchantExtractor
extends Extractor {
    @Inject
    public EnchantExtractor() {
    }

    public Optional<Enchant> extract(MessageReceiveEvent event) {
        MinecraftTranslationKey translationKey = event.getTranslationKey();
        if (!translationKey.startsWith("commands.enchant.success")) {
            return Optional.empty();
        }
        if (translationKey == MinecraftTranslationKey.COMMANDS_ENCHANT_SUCCESS) {
            Enchant enchant = new Enchant("", "", "");
            return Optional.of(enchant);
        }
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent.args().size() < 2) {
            return Optional.empty();
        }
        Component component = translatableComponent.args().get(0);
        if (!(component instanceof TranslatableComponent)) {
            return Optional.empty();
        }
        TranslatableComponent enchantComponent = (TranslatableComponent)component;
        String enchantKey = enchantComponent.key();
        if (enchantComponent.children().size() < 2) {
            return Optional.empty();
        }
        Component component2 = enchantComponent.children().get(1);
        if (!(component2 instanceof TranslatableComponent)) {
            return Optional.empty();
        }
        TranslatableComponent levelComponent = (TranslatableComponent)component2;
        String levelKey = levelComponent.key();
        Component component3 = translatableComponent.args().get(1);
        if (!(component3 instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent targetComponent = (TextComponent)component3;
        String target = this.extractTarget(targetComponent);
        Enchant enchant = new Enchant(enchantKey, levelKey, target);
        return Optional.of(enchant);
    }
}

