/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.enchant.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.enchant.EnchantModule;
import net.flectone.pulse.module.message.enchant.extractor.EnchantExtractor;
import net.flectone.pulse.module.message.enchant.model.Enchant;

@Singleton
public class EnchantPulseListener
implements PulseListener {
    private final EnchantModule enchantModule;
    private final EnchantExtractor enchantExtractor;

    @Inject
    public EnchantPulseListener(EnchantModule enchantModule, EnchantExtractor enchantExtractor) {
        this.enchantModule = enchantModule;
        this.enchantExtractor = enchantExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        Optional<Enchant> enchant = this.enchantExtractor.extract(event);
        if (enchant.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.enchantModule.send(event.getFPlayer(), event.getTranslationKey(), enchant.get());
    }
}

