/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format;

import java.util.EnumMap;
import java.util.Map;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.fcolor.FColorModule;
import net.flectone.pulse.module.message.format.fixation.FixationModule;
import net.flectone.pulse.module.message.format.listener.FormatPulseListener;
import net.flectone.pulse.module.message.format.listener.LegacyColorPulseListener;
import net.flectone.pulse.module.message.format.mention.MentionModule;
import net.flectone.pulse.module.message.format.moderation.ModerationModule;
import net.flectone.pulse.module.message.format.name.NameModule;
import net.flectone.pulse.module.message.format.questionanswer.QuestionAnswerModule;
import net.flectone.pulse.module.message.format.replacement.ReplacementModule;
import net.flectone.pulse.module.message.format.scoreboard.ScoreboardModule;
import net.flectone.pulse.module.message.format.translate.TranslateModule;
import net.flectone.pulse.module.message.format.world.WorldModule;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.AdventureTag;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;

@Singleton
public class FormatModule
extends AbstractModuleLocalization<Localization.Message.Format> {
    private final Map<AdventureTag, TagResolver> tagResolverMap = new EnumMap<AdventureTag, TagResolver>(AdventureTag.class);
    private final Message.Format message;
    private final Permission.Message.Format permission;
    private final ListenerRegistry listenerRegistry;
    private final PermissionChecker permissionChecker;

    @Inject
    public FormatModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, PermissionChecker permissionChecker) {
        super(localization -> localization.getMessage().getFormat(), MessageType.FORMAT);
        this.message = fileResolver.getMessage().getFormat();
        this.permission = fileResolver.getPermission().getMessage().getFormat();
        this.listenerRegistry = listenerRegistry;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.registerPermission(this.permission.getLegacyColors());
        this.message.getAdventureTags().forEach(adventureTag -> this.registerPermission(this.permission.getAdventureTags().get(adventureTag)));
        this.putAdventureTag(AdventureTag.HOVER, StandardTags.hoverEvent());
        this.putAdventureTag(AdventureTag.CLICK, StandardTags.clickEvent());
        this.putAdventureTag(AdventureTag.COLOR, StandardTags.color());
        this.putAdventureTag(AdventureTag.KEYBIND, StandardTags.keybind());
        this.putAdventureTag(AdventureTag.TRANSLATABLE, StandardTags.translatable());
        this.putAdventureTag(AdventureTag.TRANSLATABLE_FALLBACK, StandardTags.translatableFallback());
        this.putAdventureTag(AdventureTag.INSERTION, StandardTags.insertion());
        this.putAdventureTag(AdventureTag.FONT, StandardTags.font());
        this.putAdventureTag(AdventureTag.DECORATION, StandardTags.decorations());
        this.putAdventureTag(AdventureTag.GRADIENT, StandardTags.gradient());
        this.putAdventureTag(AdventureTag.RAINBOW, StandardTags.rainbow());
        this.putAdventureTag(AdventureTag.RESET, StandardTags.reset());
        this.putAdventureTag(AdventureTag.NEWLINE, StandardTags.newline());
        this.putAdventureTag(AdventureTag.TRANSITION, StandardTags.transition());
        this.putAdventureTag(AdventureTag.SELECTOR, StandardTags.selector());
        this.putAdventureTag(AdventureTag.SCORE, StandardTags.score());
        this.putAdventureTag(AdventureTag.NBT, StandardTags.nbt());
        this.putAdventureTag(AdventureTag.PRIDE, StandardTags.pride());
        this.putAdventureTag(AdventureTag.SHADOW_COLOR, StandardTags.shadowColor());
        this.addChildren(FColorModule.class);
        this.addChildren(FixationModule.class);
        this.addChildren(MentionModule.class);
        this.addChildren(ModerationModule.class);
        this.addChildren(NameModule.class);
        this.addChildren(QuestionAnswerModule.class);
        this.addChildren(ReplacementModule.class);
        this.addChildren(ScoreboardModule.class);
        this.addChildren(TranslateModule.class);
        this.addChildren(WorldModule.class);
        this.listenerRegistry.register(FormatPulseListener.class);
        if (this.message.isConvertLegacyColor()) {
            this.listenerRegistry.register(LegacyColorPulseListener.class);
        }
    }

    @Override
    public void onDisable() {
        this.tagResolverMap.clear();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void addTags(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        boolean isUserMessage = messageContext.isFlag(MessageFlag.USER_MESSAGE);
        this.tagResolverMap.entrySet().stream().filter(entry -> this.isCorrectTag((AdventureTag)((Object)((Object)entry.getKey())), sender, isUserMessage)).forEach(entry -> messageContext.addReplacementTag((TagResolver)entry.getValue()));
    }

    public boolean isCorrectTag(AdventureTag adventureTag, FEntity sender, boolean needPermission) {
        if (!this.message.getAdventureTags().contains((Object)adventureTag)) {
            return false;
        }
        if (!this.tagResolverMap.containsKey((Object)adventureTag)) {
            return false;
        }
        return !needPermission || this.permissionChecker.check(sender, this.permission.getAdventureTags().get((Object)adventureTag));
    }

    private void putAdventureTag(AdventureTag adventureTag, TagResolver tagResolver) {
        if (this.message.getAdventureTags().contains((Object)adventureTag)) {
            this.tagResolverMap.put(adventureTag, tagResolver);
        }
    }
}

