/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.fixation;

import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.fixation.listener.FixationPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class FixationModule
extends AbstractModule {
    private final Message.Format.Fixation message;
    private final Permission.Message.Format.Fixation permission;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public FixationModule(FileResolver fileResolver, ListenerRegistry listenerRegistry) {
        this.message = fileResolver.getMessage().getFormat().getFixation();
        this.permission = fileResolver.getPermission().getMessage().getFormat().getFixation();
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.listenerRegistry.register(FixationPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void format(MessageContext messageContext) {
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        Object contextMessage = messageContext.getMessage();
        if (((String)contextMessage).isBlank()) {
            return;
        }
        if (this.message.isEndDot()) {
            if (this.message.getNonDotSymbols().stream().noneMatch(((String)contextMessage)::endsWith)) {
                contextMessage = (String)contextMessage + ".";
            }
        }
        if (this.message.isFirstLetterUppercase()) {
            contextMessage = Character.toUpperCase(((String)contextMessage).charAt(0)) + ((String)contextMessage).substring(1);
        }
        messageContext.setMessage((String)contextMessage);
    }
}

