/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.caps;

import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.moderation.caps.listener.CapsPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class CapsModule
extends AbstractModule {
    private final Message.Format.Moderation.Caps message;
    private final Permission.Message.Format.Moderation.Caps permission;
    private final PermissionChecker permissionChecker;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public CapsModule(FileResolver fileResolver, PermissionChecker permissionChecker, ListenerRegistry listenerRegistry) {
        this.message = fileResolver.getMessage().getFormat().getModeration().getCaps();
        this.permission = fileResolver.getPermission().getMessage().getFormat().getModeration().getCaps();
        this.permissionChecker = permissionChecker;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.listenerRegistry.register(CapsPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void format(MessageContext messageContext) {
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (this.permissionChecker.check(sender, this.permission.getBypass())) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        String formattedMessage = this.needApplyAntiCaps(contextMessage) ? contextMessage.toLowerCase() : contextMessage;
        messageContext.setMessage(formattedMessage);
    }

    private boolean needApplyAntiCaps(String string) {
        int uppercaseCount = 0;
        int totalLetters = 0;
        for (char symbol : string.toCharArray()) {
            if (!Character.isLetter(symbol)) continue;
            ++totalLetters;
            if (!Character.isUpperCase(symbol)) continue;
            ++uppercaseCount;
        }
        return totalLetters > 0 && (double)uppercaseCount / (double)totalLetters > this.message.getTrigger();
    }
}

