/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.delete.listener;

import java.util.UUID;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.model.event.player.PlayerQuitEvent;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.module.message.format.moderation.delete.DeleteModule;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;

@Singleton
public class DeletePulseListener
implements PulseListener {
    private final DeleteModule deleteModule;

    @Inject
    public DeletePulseListener(DeleteModule deleteModule) {
        this.deleteModule = deleteModule;
    }

    @Pulse
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        if (!messageContext.isFlag(MessageFlag.DELETE)) {
            return;
        }
        this.deleteModule.addTag(messageContext);
    }

    @Pulse(priority=Event.Priority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.deleteModule.clearHistory(fPlayer);
    }

    @Pulse(priority=Event.Priority.MONITOR)
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        if (event.isOverlay()) {
            return;
        }
        Component component = event.getComponent();
        if (event.getTranslationKey() != MinecraftTranslationKey.UNKNOWN) {
            return;
        }
        if (this.deleteModule.isCached(component)) {
            this.deleteModule.removeCache(component);
            return;
        }
        FPlayer fReceiver = event.getFPlayer();
        UUID messageUUID = UUID.randomUUID();
        this.deleteModule.save(fReceiver, messageUUID, component, false);
    }

    @Pulse(priority=Event.Priority.MONITOR)
    public void onSenderToReceiverMessageEvent(MessageSendEvent event) {
        EventMetadata<?> eventMetadata = event.getEventMetadata();
        if (eventMetadata.getDestination().getType() != Destination.Type.CHAT) {
            return;
        }
        FPlayer fReceiver = event.getReceiver();
        UUID messageUUID = eventMetadata.getUuid();
        Component component = event.getMessage();
        this.deleteModule.save(fReceiver, messageUUID, component, true);
    }
}

