/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.newbie;

import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.PlatformType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class NewbieModule
extends AbstractModuleLocalization<Localization.Message.Format.Moderation.Newbie> {
    private final Message.Format.Moderation.Newbie message;
    private final Permission.Message.Format.Moderation.Newbie permission;
    private final PermissionChecker permissionChecker;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final PlatformServerAdapter platformServerAdapter;
    private final FLogger fLogger;

    @Inject
    public NewbieModule(FileResolver fileResolver, PermissionChecker permissionChecker, PlatformPlayerAdapter platformPlayerAdapter, PlatformServerAdapter platformServerAdapter, FLogger fLogger) {
        super(localization -> localization.getMessage().getFormat().getModeration().getNewbie(), MessageType.NEWBIE);
        this.message = fileResolver.getMessage().getFormat().getModeration().getNewbie();
        this.permission = fileResolver.getPermission().getMessage().getFormat().getModeration().getNewbie();
        this.permissionChecker = permissionChecker;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.platformServerAdapter = platformServerAdapter;
        this.fLogger = fLogger;
    }

    @Override
    public void onEnable() {
        if (this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC && this.message.getMode() == Message.Format.Moderation.Newbie.Mode.PLAYED_TIME) {
            this.fLogger.warning("Newbie module is disabled! Mode PLAYED_TIME is not supported on Fabric");
            return;
        }
        this.registerModulePermission(this.permission);
        this.registerPermission(this.permission.getBypass());
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public boolean isNewBie(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return false;
        }
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission.getBypass())) {
            return false;
        }
        long timeToCheck = switch (this.message.getMode()) {
            default -> throw new MatchException(null, null);
            case Message.Format.Moderation.Newbie.Mode.SINCE_JOIN -> System.currentTimeMillis() - this.platformPlayerAdapter.getFirstPlayed(fPlayer);
            case Message.Format.Moderation.Newbie.Mode.PLAYED_TIME -> this.platformPlayerAdapter.getAllTimePlayed(fPlayer);
        };
        long timeout = this.message.getTimeout() * 1000L;
        return timeToCheck <= timeout;
    }

    public ExternalModeration getModeration(FPlayer fPlayer) {
        if (!this.isNewBie(fPlayer)) {
            return null;
        }
        long timeout = this.message.getTimeout() * 1000L;
        long firstPlayed = this.platformPlayerAdapter.getFirstPlayed(fPlayer);
        long moderationTime = switch (this.message.getMode()) {
            default -> throw new MatchException(null, null);
            case Message.Format.Moderation.Newbie.Mode.SINCE_JOIN -> firstPlayed + timeout;
            case Message.Format.Moderation.Newbie.Mode.PLAYED_TIME -> System.currentTimeMillis() + (timeout - this.platformPlayerAdapter.getAllTimePlayed(fPlayer));
        };
        return new ExternalModeration(fPlayer.getName(), FPlayer.UNKNOWN.getName(), ((Localization.Message.Format.Moderation.Newbie)this.resolveLocalization()).getReason(), 1L, firstPlayed, moderationTime, false);
    }
}

