/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.swear;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guava.cache.CacheBuilder;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.moderation.swear.listener.SwearPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.minimessage.tag.Tag;

@Singleton
public class SwearModule
extends AbstractModuleLocalization<Localization.Message.Format.Moderation.Swear> {
    private final Cache<String, String> messageCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100000L).build();
    private final Message.Format.Moderation.Swear message;
    private final Permission.Message.Format.Moderation.Swear permission;
    private final FLogger fLogger;
    private final ListenerRegistry listenerRegistry;
    private final PermissionChecker permissionChecker;
    private final MessagePipeline messagePipeline;
    private Pattern combinedPattern;

    @Inject
    public SwearModule(FileResolver fileResolver, FLogger fLogger, ListenerRegistry listenerRegistry, PermissionChecker permissionChecker, MessagePipeline messagePipeline) {
        super(localization -> localization.getMessage().getFormat().getModeration().getSwear(), MessageType.SWEAR);
        this.message = fileResolver.getMessage().getFormat().getModeration().getSwear();
        this.permission = fileResolver.getPermission().getMessage().getFormat().getModeration().getSwear();
        this.fLogger = fLogger;
        this.listenerRegistry = listenerRegistry;
        this.permissionChecker = permissionChecker;
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.registerPermission(this.permission.getBypass());
        this.registerPermission(this.permission.getSee());
        try {
            this.combinedPattern = Pattern.compile(String.join((CharSequence)"|", this.message.getTrigger()));
        }
        catch (PatternSyntaxException e) {
            this.fLogger.warning(e);
        }
        this.listenerRegistry.register(SwearPulseListener.class);
    }

    @Override
    public void onDisable() {
        this.messageCache.invalidateAll();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void format(MessageContext messageContext) {
        String formattedMessage;
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        try {
            formattedMessage = (String)this.messageCache.get((Object)contextMessage, () -> this.replace(sender, contextMessage));
        }
        catch (ExecutionException e) {
            this.fLogger.warning(e);
            formattedMessage = this.replace(sender, contextMessage);
        }
        messageContext.setMessage(formattedMessage);
    }

    public void addTag(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.SWEAR, (argumentQueue, context) -> {
            Tag.Argument swearTag = argumentQueue.peek();
            if (swearTag == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String swear = swearTag.value();
            if (swear.isBlank()) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String symbols = ((Localization.Message.Format.Moderation.Swear)this.resolveLocalization(receiver)).getSymbol().repeat(swear.length());
            StyleSetter<Component> component = this.messagePipeline.builder(sender, receiver, symbols).build();
            if (this.permissionChecker.check((FEntity)receiver, this.permission.getSee())) {
                component = component.hoverEvent(HoverEvent.showText(Component.text(swear)));
            }
            return Tag.selfClosingInserting((Component)component);
        });
    }

    private String replace(FEntity sender, String string) {
        if (this.permissionChecker.check(sender, this.permission.getBypass())) {
            return string;
        }
        if (this.combinedPattern == null) {
            return string;
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = this.combinedPattern.matcher(string);
        while (matcher.find()) {
            String word = matcher.group(0);
            if (word != null && this.message.getIgnore().contains(word.trim().toLowerCase())) continue;
            matcher.appendReplacement(result, "<swear:'" + word + "'>");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @Generated
    public Pattern getCombinedPattern() {
        return this.combinedPattern;
    }
}

