/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.name;

import java.util.Set;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.name.listener.NamePulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;

@Singleton
public class NameModule
extends AbstractModuleLocalization<Localization.Message.Format.Name> {
    private final Message.Format.Name message;
    private final Permission.Message.Format.Name permission;
    private final ListenerRegistry listenerRegistry;
    private final IntegrationModule integrationModule;
    private final MessagePipeline messagePipeline;

    @Inject
    public NameModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, IntegrationModule integrationModule, MessagePipeline messagePipeline) {
        super(localization -> localization.getMessage().getFormat().getName_(), MessageType.NAME);
        this.message = fileResolver.getMessage().getFormat().getName_();
        this.permission = fileResolver.getPermission().getMessage().getFormat().getName_();
        this.listenerRegistry = listenerRegistry;
        this.integrationModule = integrationModule;
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.listenerRegistry.register(NamePulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void addTags(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        if (!(sender instanceof FPlayer)) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.DISPLAY_NAME, (argumentQueue, context) -> {
                String formatEntity = StringUtils.replaceEach((String)((Localization.Message.Format.Name)this.resolveLocalization(receiver)).getEntity(), (String[])new String[]{"<name>", "<type>", "<uuid>"}, (String[])new String[]{sender.getName(), sender.getType(), sender.getUuid().toString()});
                Component name = this.messagePipeline.builder(sender, receiver, formatEntity).build();
                return Tag.selfClosingInserting((Component)name);
            });
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.CONSTANT, (argumentQueue, context) -> {
            String constantName = fPlayer.getConstantName();
            if (constantName == null) {
                constantName = ((Localization.Message.Format.Name)this.resolveLocalization(fPlayer)).getConstant();
            }
            if (constantName.isEmpty()) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.preProcessParsed((String)this.messagePipeline.builder(fPlayer, constantName).defaultSerializerBuild());
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.DISPLAY_NAME, (argumentQueue, context) -> {
            Localization.Message.Format.Name localization = (Localization.Message.Format.Name)this.resolveLocalization(receiver);
            String displayName = fPlayer.isUnknown() ? Strings.CS.replace(localization.getUnknown(), "<name>", fPlayer.getName()) : localization.getDisplay();
            Component displayNameComponent = this.messagePipeline.builder(sender, receiver, displayName).build();
            return Tag.selfClosingInserting((Component)displayNameComponent);
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.VAULT_PREFIX, (argumentQueue, context) -> {
            String prefix = this.integrationModule.getPrefix(fPlayer);
            if (StringUtils.isEmpty((CharSequence)prefix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String text = this.messagePipeline.builder(fPlayer, receiver, prefix).defaultSerializerBuild();
            return Tag.preProcessParsed((String)text);
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.VAULT_SUFFIX, (argumentQueue, context) -> {
            String suffix = this.integrationModule.getSuffix(fPlayer);
            if (StringUtils.isEmpty((CharSequence)suffix)) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String text = this.messagePipeline.builder(fPlayer, receiver, suffix).defaultSerializerBuild();
            return Tag.preProcessParsed((String)text);
        });
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.PLAYER, (argumentQueue, context) -> Tag.preProcessParsed((String)fPlayer.getName()));
    }

    public void addInvisibleTag(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(Set.of(MessagePipeline.ReplacementTag.DISPLAY_NAME, MessagePipeline.ReplacementTag.PLAYER), (argumentQueue, context) -> {
            String formatInvisible = ((Localization.Message.Format.Name)this.resolveLocalization(receiver)).getInvisible();
            Component name = this.messagePipeline.builder(sender, receiver, formatInvisible).build();
            return Tag.selfClosingInserting((Component)name);
        });
    }
}

