/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.translate;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guava.cache.CacheBuilder;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.translate.listener.TranslatePulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.jetbrains.annotations.Nullable;

@Singleton
public class TranslateModule
extends AbstractModuleLocalization<Localization.Message.Format.Translate> {
    private final Cache<String, UUID> messageCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final Message.Format.Translate message;
    private final Permission.Message.Format.Translate permission;
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;

    @Inject
    public TranslateModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, MessagePipeline messagePipeline) {
        super(localization -> localization.getMessage().getFormat().getTranslate(), MessageType.TRANSLATE);
        this.message = fileResolver.getMessage().getFormat().getTranslate();
        this.permission = fileResolver.getPermission().getMessage().getFormat().getTranslate();
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.listenerRegistry.register(TranslatePulseListener.class);
    }

    @Override
    public void onDisable() {
        this.messageCache.invalidateAll();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public UUID saveMessage(String message) {
        UUID uuid = (UUID)this.messageCache.getIfPresent((Object)message);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.messageCache.put((Object)message, (Object)uuid);
        }
        return uuid;
    }

    public void addTag(MessageContext messageContext, UUID key) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(Set.of(MessagePipeline.ReplacementTag.TRANSLATE, MessagePipeline.ReplacementTag.TRANSLATETO), (argumentQueue, context) -> {
            String firstLang = "auto";
            String secondLang = receiver.getSettingValue(FPlayer.Setting.LOCALE);
            if (argumentQueue.hasNext()) {
                Tag.Argument first = argumentQueue.pop();
                if (argumentQueue.hasNext()) {
                    Tag.Argument second = argumentQueue.pop();
                    if (argumentQueue.hasNext()) {
                        firstLang = first.value();
                        secondLang = second.value();
                    } else {
                        secondLang = first.value();
                    }
                }
            }
            String action = ((Localization.Message.Format.Translate)this.resolveLocalization(receiver)).getAction();
            action = Strings.CS.replaceOnce(action, "<language>", firstLang);
            action = Strings.CS.replaceOnce(action, "<language>", secondLang == null ? "ru_ru" : secondLang);
            action = Strings.CS.replace(action, "<message>", key.toString());
            Component component = this.messagePipeline.builder(sender, receiver, action).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).flag(MessageFlag.TRANSLATE, false).build();
            return Tag.selfClosingInserting((Component)component);
        });
    }

    public String getMessage(String stringUUID) {
        try {
            UUID uuid = UUID.fromString(stringUUID);
            return this.getMessage(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public String getMessage(UUID uuid) {
        return this.messageCache.asMap().entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(uuid)).findFirst().map(Map.Entry::getKey).orElse(null);
    }
}

