/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.gamemode;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.gamemode.listener.GamemodePulseListener;
import net.flectone.pulse.module.message.gamemode.model.Gamemode;
import net.flectone.pulse.module.message.gamemode.model.GamemodeMetadata;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class GamemodeModule
extends AbstractModuleLocalization<Localization.Message.Gamemode> {
    private final Message.Gamemode message;
    private final Permission.Message.Gamemode permission;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Inject
    public GamemodeModule(FileResolver fileResolver, FPlayerService fPlayerService, ListenerRegistry listenerRegistry, PlatformPlayerAdapter platformPlayerAdapter) {
        super(localization -> localization.getMessage().getGamemode(), MessageType.GAMEMODE);
        this.message = fileResolver.getMessage().getGamemode();
        this.permission = fileResolver.getPermission().getMessage().getGamemode();
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(GamemodePulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, Gamemode gamemode) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(gamemode.target());
        if (fTarget.isUnknown()) {
            return;
        }
        boolean isSelf = fPlayer.equals(fTarget);
        String gamemodeType = gamemode.type().isEmpty() ? this.platformPlayerAdapter.getGamemode(fTarget).name().toLowerCase() : gamemode.type().split("\\.")[1];
        this.sendMessage(((GamemodeMetadata.GamemodeMetadataBuilder)((GamemodeMetadata.GamemodeMetadataBuilder)((EventMetadata.EventMetadataBuilder)((GamemodeMetadata.GamemodeMetadataBuilder)((GamemodeMetadata.GamemodeMetadataBuilder)((GamemodeMetadata.GamemodeMetadataBuilder)GamemodeMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(s -> Strings.CS.replace(isSelf ? s.getFormatSelf() : s.getFormatOther(), "<gamemode>", gamemodeType))).gamemode(gamemode)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

