/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.gamemode.extractor;

import java.util.Optional;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.gamemode.model.Gamemode;
import net.flectone.pulse.processing.extractor.Extractor;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;

@Singleton
public class GamemodeExtractor
extends Extractor {
    @Inject
    public GamemodeExtractor() {
    }

    public Optional<Gamemode> extract(MessageReceiveEvent event) {
        String target = event.getFPlayer().getName();
        String gamemodeKey = "";
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent.args().isEmpty()) {
            Gamemode gamemode = new Gamemode(gamemodeKey, target);
            return Optional.of(gamemode);
        }
        Component component = translatableComponent.args().get(0);
        if (component instanceof TranslatableComponent) {
            TranslatableComponent gamemodeComponent = (TranslatableComponent)component;
            gamemodeKey = gamemodeComponent.key();
        } else if (translatableComponent.args().size() > 1 && (component = translatableComponent.args().get(0)) instanceof TextComponent) {
            TextComponent playerComponent = (TextComponent)component;
            component = translatableComponent.args().get(1);
            if (component instanceof TranslatableComponent) {
                TranslatableComponent gamemodeComponent = (TranslatableComponent)component;
                target = this.extractTarget(playerComponent);
                gamemodeKey = gamemodeComponent.key();
            }
        }
        Gamemode gamemode = new Gamemode(gamemodeKey, target);
        return Optional.of(gamemode);
    }
}

