/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.gamemode.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.gamemode.GamemodeModule;
import net.flectone.pulse.module.message.gamemode.extractor.GamemodeExtractor;
import net.flectone.pulse.module.message.gamemode.model.Gamemode;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class GamemodePulseListener
implements PulseListener {
    private final GamemodeModule gamemodeModule;
    private final GamemodeExtractor gamemodeExtractor;

    @Inject
    public GamemodePulseListener(GamemodeModule gamemodeModule, GamemodeExtractor gamemodeExtractor) {
        this.gamemodeModule = gamemodeModule;
        this.gamemodeExtractor = gamemodeExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        MinecraftTranslationKey key = event.getTranslationKey();
        if (!key.startsWith("commands.gamemode.success") && key != MinecraftTranslationKey.GAMEMODE_CHANGED) {
            return;
        }
        Optional<Gamemode> gamemode = this.gamemodeExtractor.extract(event);
        if (gamemode.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.gamemodeModule.send(event.getFPlayer(), gamemode.get());
    }
}

