/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.greeting;

import java.io.IOException;
import java.util.List;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.FImage;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.greeting.listener.GreetingPulseListener;
import net.flectone.pulse.module.message.greeting.model.GreetingMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class GreetingModule
extends AbstractModuleLocalization<Localization.Message.Greeting> {
    private final Message.Greeting message;
    private final Permission.Message.Greeting permission;
    private final SkinService skinService;
    private final FLogger fLogger;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public GreetingModule(FileResolver fileResolver, SkinService skinService, FLogger fLogger, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getGreeting(), MessageType.GREETING);
        this.message = fileResolver.getMessage().getGreeting();
        this.permission = fileResolver.getPermission().getMessage().getGreeting();
        this.skinService = skinService;
        this.fLogger = fLogger;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(GreetingPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FImage fImage = new FImage(this.skinService.getAvatarUrl(fPlayer));
        try {
            List<String> pixels = fImage.convertImageUrl();
            this.sendMessage(((GreetingMetadata.GreetingMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)((EventMetadata.EventMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)GreetingMetadata.builder().sender(fPlayer)).format(s -> {
                String greetingMessage = String.join((CharSequence)"<br>", ((Localization.Message.Greeting)this.resolveLocalization(fPlayer)).getFormat());
                for (String pixel : pixels) {
                    greetingMessage = Strings.CS.replaceOnce(greetingMessage, "[#][#][#][#][#][#][#][#]", pixel);
                }
                return greetingMessage;
            })).pixels(pixels)).destination(this.message.getDestination())).sound(this.getModuleSound())).filter(fReceiver -> fReceiver.isSetting(FPlayer.Setting.GREETING))).build());
        }
        catch (IOException e) {
            this.fLogger.warning(e);
        }
    }
}

