/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.join;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.join.listener.JoinPulseListener;
import net.flectone.pulse.module.message.join.model.JoinMetadata;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class JoinModule
extends AbstractModuleLocalization<Localization.Message.Join> {
    private final Message.Join message;
    private final Permission.Message.Join permission;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final IntegrationModule integrationModule;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public JoinModule(FileResolver fileResolver, PlatformPlayerAdapter platformPlayerAdapter, IntegrationModule integrationModule, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getJoin(), MessageType.JOIN);
        this.message = fileResolver.getMessage().getJoin();
        this.permission = fileResolver.getPermission().getMessage().getJoin();
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.integrationModule = integrationModule;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(JoinPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async(delay=5L)
    public void sendLater(FPlayer fPlayer) {
        this.send(fPlayer, false);
    }

    @Async
    public void send(FPlayer fPlayer, boolean ignoreVanish) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        boolean hasPlayedBefore = this.platformPlayerAdapter.hasPlayedBefore(fPlayer);
        this.sendMessage(((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((EventMetadata.EventMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)JoinMetadata.builder().sender(fPlayer)).format(s -> hasPlayedBefore || !this.message.isFirst() ? s.getFormat() : s.getFormatFirstTime())).ignoreVanish(ignoreVanish)).playedBefore(hasPlayedBefore)).destination(this.message.getDestination())).range(this.message.getRange())).sound(this.getModuleSound())).filter(fReceiver -> fReceiver.isSetting(FPlayer.Setting.JOIN) && (ignoreVanish || this.integrationModule.canSeeVanished(fPlayer, (FEntity)fReceiver)))).proxy(dataOutputStream -> {
            dataOutputStream.writeBoolean(hasPlayedBefore);
            dataOutputStream.writeBoolean(ignoreVanish);
        })).integration()).build());
    }
}

