/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.join.listener;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.module.message.join.JoinModule;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class JoinPulseListener
implements PulseListener {
    private final PacketProvider packetProvider;
    private final JoinModule joinModule;

    @Inject
    public JoinPulseListener(PacketProvider packetProvider, JoinModule joinModule) {
        this.packetProvider = packetProvider;
        this.joinModule = joinModule;
    }

    @Pulse
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fPlayer = event.getPlayer();
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
            this.joinModule.sendLater(fPlayer);
        } else {
            this.joinModule.send(fPlayer, false);
        }
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        if (event.getTranslationKey() != MinecraftTranslationKey.MULTIPLAYER_PLAYER_JOINED) {
            return;
        }
        event.setCancelled(true);
    }
}

