/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.kill;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.kill.listener.KillPulseListener;
import net.flectone.pulse.module.message.kill.model.Kill;
import net.flectone.pulse.module.message.kill.model.KillMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class KillModule
extends AbstractModuleLocalization<Localization.Message.Kill> {
    private final Message.Kill message;
    private final Permission.Message.Kill permission;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public KillModule(FileResolver fileResolver, FPlayerService fPlayerService, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getKill(), MessageType.KILL);
        this.message = fileResolver.getMessage().getKill();
        this.permission = fileResolver.getPermission().getMessage().getKill();
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(KillPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey key, Kill kill) {
        boolean isSingle;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FEntity fTarget = fPlayer;
        boolean bl = isSingle = key == MinecraftTranslationKey.COMMANDS_KILL_SUCCESS_SINGLE || key == MinecraftTranslationKey.COMMANDS_KILL_SUCCESS;
        if (isSingle && kill.getEntityUUID() != null && ((FEntity)(fTarget = this.fPlayerService.getFPlayer(kill.getEntityUUID()))).isUnknown()) {
            fTarget = kill.fEntity();
        }
        this.sendMessage(((KillMetadata.KillMetadataBuilder)((KillMetadata.KillMetadataBuilder)((EventMetadata.EventMetadataBuilder)((KillMetadata.KillMetadataBuilder)((KillMetadata.KillMetadataBuilder)((KillMetadata.KillMetadataBuilder)KillMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(s -> key == MinecraftTranslationKey.COMMANDS_KILL_SUCCESS_MULTIPLE ? Strings.CS.replace(s.getMultiple(), "<count>", kill.value()) : s.getSingle())).kill(kill)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

