/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.kill.extractor;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.kill.model.Kill;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.EntityUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import org.incendo.cloud.type.tuple.Triplet;

@Singleton
public class KillExtractor
extends Extractor {
    private final EntityUtil entityUtil;
    private final FPlayerService fPlayerService;

    @Inject
    public KillExtractor(EntityUtil entityUtil, FPlayerService fPlayerService) {
        this.entityUtil = entityUtil;
        this.fPlayerService = fPlayerService;
    }

    public Optional<Kill> extractMultipleKill(MessageReceiveEvent event) {
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        Component component = translatableComponent.args().get(0);
        if (!(component instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent firstArgument = (TextComponent)component;
        String value = firstArgument.content();
        Kill kill = new Kill(value, null);
        return Optional.of(kill);
    }

    public Optional<Kill> extractSingleKill(MessageReceiveEvent event) {
        String content;
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (translatableComponent.args().isEmpty()) {
            return Optional.empty();
        }
        Component firstArgument = translatableComponent.args().get(0);
        UUID uuid = null;
        Component component = firstArgument;
        Objects.requireNonNull(component);
        Component component2 = component;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslatableComponent.class, TextComponent.class}, (Object)component2, n)) {
            case 0: {
                String string;
                TranslatableComponent translatableArg = (TranslatableComponent)component2;
                String insertion = translatableArg.insertion();
                if (StringUtils.isNotEmpty((CharSequence)insertion)) {
                    try {
                        uuid = UUID.fromString(insertion);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                String string2 = string = translatableArg.key();
                break;
            }
            case 1: {
                String string;
                TextComponent textArg = (TextComponent)component2;
                String string2 = string = textArg.content();
                break;
            }
            default: {
                String string;
                String string2 = content = (string = null);
            }
        }
        if (content == null) {
            return Optional.empty();
        }
        Triplet<String, String, UUID> triplet = this.extractHoverComponent(content, content, uuid, firstArgument.hoverEvent());
        String name = (String)triplet.first();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        String type = (String)triplet.second();
        uuid = (UUID)triplet.third();
        event.setCancelled(true);
        FEntity fEntity = new FEntity(name, uuid, type);
        Kill kill = new Kill("", fEntity);
        return Optional.of(kill);
    }

    private Triplet<String, String, UUID> extractHoverComponent(String name, String type, UUID uuid, HoverEvent<?> hoverEvent) {
        if (hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent.value();
            uuid = showEntity.id();
            type = this.entityUtil.resolveEntityTranslationKey(showEntity.type().key().value());
            Component component = showEntity.name();
            if (component instanceof TextComponent) {
                TextComponent hoverText = (TextComponent)component;
                name = hoverText.content();
            } else {
                component = showEntity.name();
                if (component instanceof TranslatableComponent) {
                    TranslatableComponent hoverTranslatable = (TranslatableComponent)component;
                    name = hoverTranslatable.key();
                }
            }
        } else if (uuid == null) {
            uuid = this.fPlayerService.getFPlayer(name).getUuid();
        }
        return Triplet.of((Object)name, (Object)type, (Object)uuid);
    }
}

