/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.kill.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.kill.KillModule;
import net.flectone.pulse.module.message.kill.extractor.KillExtractor;
import net.flectone.pulse.module.message.kill.model.Kill;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class KillPulseListener
implements PulseListener {
    private final KillModule killModule;
    private final KillExtractor killExtractor;

    @Inject
    public KillPulseListener(KillModule killModule, KillExtractor killExtractor) {
        this.killModule = killModule;
        this.killExtractor = killExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        Optional kill;
        MinecraftTranslationKey translationKey = event.getTranslationKey();
        switch (translationKey) {
            case COMMANDS_KILL_SUCCESS_MULTIPLE: {
                Optional<Object> optional = this.killExtractor.extractMultipleKill(event);
                break;
            }
            case COMMANDS_KILL_SUCCESS_SINGLE: 
            case COMMANDS_KILL_SUCCESS: {
                Optional<Object> optional = this.killExtractor.extractSingleKill(event);
                break;
            }
            default: {
                Optional<Object> optional = kill = Optional.empty();
            }
        }
        if (kill.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.killModule.send(event.getFPlayer(), translationKey, (Kill)kill.get());
    }
}

