/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.objective.belowname;

import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.objective.ObjectiveModule;
import net.flectone.pulse.module.message.objective.ScoreboardPosition;
import net.flectone.pulse.module.message.objective.belowname.listener.BelownamePulseListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;

@Singleton
public class BelownameModule
extends AbstractModuleLocalization<Localization.Message.Objective.Belowname> {
    private final Message.Objective.Belowname config;
    private final Permission.Message.Objective.Belowname permission;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final TaskScheduler taskScheduler;
    private final ObjectiveModule objectiveModule;
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;

    @Inject
    public BelownameModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, TaskScheduler taskScheduler, ObjectiveModule objectiveModule, ListenerRegistry listenerRegistry, MessagePipeline messagePipeline) {
        super(localization -> localization.getMessage().getObjective().getBelowname(), MessageType.OBJECTIVE);
        this.config = fileResolver.getMessage().getObjective().getBelowname();
        this.permission = fileResolver.getPermission().getMessage().getObjective().getBelowname();
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.taskScheduler = taskScheduler;
        this.objectiveModule = objectiveModule;
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        Ticker ticker = this.config.getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::update), ticker.getPeriod());
        }
        this.listenerRegistry.register(BelownamePulseListener.class);
    }

    @Override
    public void onDisable() {
        this.fPlayerService.getPlatformFPlayers().forEach(this::remove);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.config.isEnable();
    }

    public void create(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Component displayName = this.messagePipeline.builder(fPlayer, ((Localization.Message.Objective.Belowname)this.resolveLocalization(fPlayer)).getFormat()).build();
        this.objectiveModule.createObjective(fPlayer, displayName, ScoreboardPosition.BELOWNAME);
        this.update(fPlayer);
    }

    public void update(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.fPlayerService.getVisibleFPlayersFor(fPlayer).forEach(fObjective -> {
            int score = this.platformPlayerAdapter.getObjectiveScore(fObjective.getUuid(), this.config.getMode());
            this.objectiveModule.updateObjective(fPlayer, (FPlayer)fObjective, score, ScoreboardPosition.BELOWNAME);
        });
    }

    public void remove(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.objectiveModule.removeObjective(fPlayer, ScoreboardPosition.BELOWNAME);
    }
}

