/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.objective.tabname;

import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.objective.ObjectiveModule;
import net.flectone.pulse.module.message.objective.ScoreboardPosition;
import net.flectone.pulse.module.message.objective.tabname.listener.TabnamePulseListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class TabnameModule
extends AbstractModule {
    private final Message.Objective.Tabname config;
    private final Permission.Message.Objective.Tabname permission;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final TaskScheduler taskScheduler;
    private final ObjectiveModule objectiveModule;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public TabnameModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, TaskScheduler taskScheduler, ObjectiveModule objectiveModule, ListenerRegistry listenerRegistry) {
        this.config = fileResolver.getMessage().getObjective().getTabname();
        this.permission = fileResolver.getPermission().getMessage().getObjective().getTabname();
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.taskScheduler = taskScheduler;
        this.objectiveModule = objectiveModule;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        Ticker ticker = this.config.getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::update), ticker.getPeriod());
        }
        this.listenerRegistry.register(TabnamePulseListener.class);
    }

    @Override
    public void onDisable() {
        this.fPlayerService.getPlatformFPlayers().forEach(this::remove);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.config.isEnable();
    }

    public void create(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.objectiveModule.createObjective(fPlayer, null, ScoreboardPosition.TABLIST);
        this.update(fPlayer);
    }

    public void update(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.fPlayerService.getVisibleFPlayersFor(fPlayer).forEach(fObjective -> {
            int score = this.platformPlayerAdapter.getObjectiveScore(fObjective.getUuid(), this.config.getMode());
            this.objectiveModule.updateObjective(fPlayer, (FPlayer)fObjective, score, ScoreboardPosition.TABLIST);
        });
    }

    public void remove(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.objectiveModule.removeObjective(fPlayer, ScoreboardPosition.TABLIST);
    }
}

