/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.quit;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.quit.listener.QuitPulseListener;
import net.flectone.pulse.module.message.quit.model.QuitMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class QuitModule
extends AbstractModuleLocalization<Localization.Message.Quit> {
    private final Message.Quit message;
    private final Permission.Message.Quit permission;
    private final IntegrationModule integrationModule;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public QuitModule(FileResolver fileResolver, IntegrationModule integrationModule, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getQuit(), MessageType.QUIT);
        this.message = fileResolver.getMessage().getQuit();
        this.permission = fileResolver.getPermission().getMessage().getQuit();
        this.integrationModule = integrationModule;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(QuitPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, boolean ignoreVanish) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((EventMetadata.EventMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)QuitMetadata.builder().sender(fPlayer)).format(Localization.Message.Quit::getFormat)).ignoreVanish(ignoreVanish)).destination(this.message.getDestination())).range(this.message.getRange())).sound(this.getModuleSound())).filter(fReceiver -> fReceiver.isSetting(FPlayer.Setting.QUIT) && (ignoreVanish || this.integrationModule.canSeeVanished(fPlayer, (FEntity)fReceiver)))).integration()).proxy(dataOutputStream -> dataOutputStream.writeBoolean(ignoreVanish))).build());
    }
}

