/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.rightclick;

import java.util.UUID;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.rightclick.listener.RightclickPacketListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class RightclickModule
extends AbstractModuleLocalization<Localization.Message.Rightclick> {
    private final Message.Rightclick message;
    private final Permission.Message.Rightclick permission;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public RightclickModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getRightclick(), MessageType.RIGHT_CLICK);
        this.message = fileResolver.getMessage().getRightclick();
        this.permission = fileResolver.getPermission().getMessage().getRightclick();
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.createCooldown(this.message.getCooldown(), this.permission.getCooldownBypass());
        this.listenerRegistry.register(RightclickPacketListener.class);
        this.addPredicate(this::checkCooldown);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(UUID uuid, int targetId) {
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        UUID targetUUID = this.platformPlayerAdapter.getPlayerByEntityId(targetId);
        if (targetUUID == null) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(targetUUID);
        if (fTarget.isUnknown()) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fTarget)).filterPlayer(fPlayer)).format(Localization.Message.Rightclick::getFormat)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

