/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.seed;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.seed.listener.SeedPulseListener;
import net.flectone.pulse.module.message.seed.model.SeedMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class SeedModule
extends AbstractModuleLocalization<Localization.Message.Seed> {
    private final Message.Seed message;
    private final Permission.Message.Seed permission;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public SeedModule(FileResolver fileResolver, ListenerRegistry listenerRegistry) {
        super((Localization localization) -> localization.getMessage().getSeed(), MessageType.SEED);
        this.message = fileResolver.getMessage().getSeed();
        this.permission = fileResolver.getPermission().getMessage().getSeed();
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(SeedPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, String seed) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((SeedMetadata.SeedMetadataBuilder)((SeedMetadata.SeedMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SeedMetadata.SeedMetadataBuilder)((SeedMetadata.SeedMetadataBuilder)((SeedMetadata.SeedMetadataBuilder)SeedMetadata.builder().sender(fPlayer)).filterPlayer(fPlayer)).format(s -> Strings.CS.replace(s.getFormat(), "<seed>", seed))).seed(seed)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

