/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.setblock;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.setblock.listener.SetblockPulseListener;
import net.flectone.pulse.module.message.setblock.model.Setblock;
import net.flectone.pulse.module.message.setblock.model.SetblockMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class SetblockModule
extends AbstractModuleLocalization<Localization.Message.Setblock> {
    private final Message.Setblock message;
    private final Permission.Message.Setblock permission;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public SetblockModule(FileResolver fileResolver, ListenerRegistry listenerRegistry) {
        super((Localization localization) -> localization.getMessage().getSetblock(), MessageType.SETBLOCK);
        this.message = fileResolver.getMessage().getSetblock();
        this.permission = fileResolver.getPermission().getMessage().getSetblock();
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(SetblockPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, Setblock setblock) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((SetblockMetadata.SetblockMetadataBuilder)((SetblockMetadata.SetblockMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SetblockMetadata.SetblockMetadataBuilder)((SetblockMetadata.SetblockMetadataBuilder)((SetblockMetadata.SetblockMetadataBuilder)SetblockMetadata.builder().sender(fPlayer)).filterPlayer(fPlayer)).format(s -> StringUtils.replaceEach((String)s.getFormat(), (String[])new String[]{"<x>", "<y>", "<z>"}, (String[])new String[]{String.valueOf(setblock.x()), String.valueOf(setblock.y()), String.valueOf(setblock.z())}))).setblock(setblock)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

