/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.setblock.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.setblock.SetblockModule;
import net.flectone.pulse.module.message.setblock.extractor.SetblockExtractor;
import net.flectone.pulse.module.message.setblock.model.Setblock;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class SetblockPulseListener
implements PulseListener {
    private final SetblockModule setblockModule;
    private final SetblockExtractor setblockExtractor;

    @Inject
    public SetblockPulseListener(SetblockModule setblockModule, SetblockExtractor setblockExtractor) {
        this.setblockModule = setblockModule;
        this.setblockExtractor = setblockExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        if (event.getTranslationKey() != MinecraftTranslationKey.COMMANDS_SETBLOCK_SUCCESS) {
            return;
        }
        Optional<Setblock> setblock = this.setblockExtractor.extract(event);
        if (setblock.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.setblockModule.send(event.getFPlayer(), setblock.get());
    }
}

