/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.sleep;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.sleep.listener.SleepPulseListener;
import net.flectone.pulse.module.message.sleep.model.Sleep;
import net.flectone.pulse.module.message.sleep.model.SleepMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class SleepModule
extends AbstractModuleLocalization<Localization.Message.Sleep> {
    private final Message.Sleep message;
    private final Permission.Message.Sleep permission;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public SleepModule(FileResolver fileResolver, ListenerRegistry listenerRegistry) {
        super((Localization localization) -> localization.getMessage().getSleep(), MessageType.SLEEP);
        this.message = fileResolver.getMessage().getSleep();
        this.permission = fileResolver.getPermission().getMessage().getSleep();
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(SleepPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey key, Sleep sleep) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((SleepMetadata.SleepMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SleepMetadata.SleepMetadataBuilder)((SleepMetadata.SleepMetadataBuilder)((SleepMetadata.SleepMetadataBuilder)((SleepMetadata.SleepMetadataBuilder)SleepMetadata.builder().sender(fPlayer)).filterPlayer(fPlayer)).format(bed -> switch (key) {
            case MinecraftTranslationKey.SLEEP_NOT_POSSIBLE -> bed.getNotPossible();
            case MinecraftTranslationKey.SLEEP_PLAYERS_SLEEPING -> StringUtils.replaceEach((String)bed.getPlayersSleeping(), (String[])new String[]{"<sleep_count>", "<all_count>"}, (String[])new String[]{String.valueOf(sleep.sleepCount()), String.valueOf(sleep.allCount())});
            case MinecraftTranslationKey.SLEEP_SKIPPING_NIGHT -> bed.getSkippingNight();
            default -> "";
        })).destination(this.message.getDestination())).sleep(sleep)).sound(this.getModuleSound())).build());
    }
}

