/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.sleep.extractor;

import java.util.Optional;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.sleep.model.Sleep;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;

@Singleton
public class SleepExtractor
extends Extractor {
    @Inject
    public SleepExtractor() {
    }

    public Optional<Sleep> extract(MessageReceiveEvent event) {
        String sleepCount = "";
        String allCount = "";
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        if (event.getTranslationKey() == MinecraftTranslationKey.SLEEP_PLAYERS_SLEEPING && translatableComponent.args().size() == 2) {
            Component component = translatableComponent.args().get(0);
            if (component instanceof TextComponent) {
                TextComponent sleepComponent = (TextComponent)component;
                sleepCount = sleepComponent.content();
            }
            if ((component = translatableComponent.args().get(1)) instanceof TextComponent) {
                TextComponent allComponent = (TextComponent)component;
                allCount = allComponent.content();
            }
        }
        Sleep sleep = new Sleep(sleepCount, allCount);
        return Optional.of(sleep);
    }
}

