/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.sleep.listener;

import java.util.Optional;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.sleep.SleepModule;
import net.flectone.pulse.module.message.sleep.extractor.SleepExtractor;
import net.flectone.pulse.module.message.sleep.model.Sleep;

@Singleton
public class SleepPulseListener
implements PulseListener {
    private final SleepModule sleepModule;
    private final SleepExtractor sleepExtractor;

    @Inject
    public SleepPulseListener(SleepModule sleepModule, SleepExtractor sleepExtractor) {
        this.sleepModule = sleepModule;
        this.sleepExtractor = sleepExtractor;
    }

    @Pulse
    public void onTranslatableMessageReceiveEvent(MessageReceiveEvent event) {
        if (!event.getTranslationKey().startsWith("sleep.")) {
            return;
        }
        Optional<Sleep> sleep = this.sleepExtractor.extract(event);
        if (sleep.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        this.sleepModule.send(event.getFPlayer(), event.getTranslationKey(), sleep.get());
    }
}

