/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.spawn;

import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.spawn.listener.SpawnPacketListener;
import net.flectone.pulse.module.message.spawn.listener.SpawnPulseListener;
import net.flectone.pulse.module.message.spawn.model.Spawn;
import net.flectone.pulse.module.message.spawn.model.SpawnMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;

@Singleton
public class SpawnModule
extends AbstractModuleLocalization<Localization.Message.Spawn> {
    private final Message.Spawn message;
    private final Permission.Message.Spawn permission;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public SpawnModule(FileResolver fileResolver, FPlayerService fPlayerService, ListenerRegistry listenerRegistry) {
        super(localization -> localization.getMessage().getSpawn(), MessageType.SPAWN);
        this.message = fileResolver.getMessage().getSpawn();
        this.permission = fileResolver.getPermission().getMessage().getSpawn();
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.createSound(this.message.getSound(), this.permission.getSound());
        this.listenerRegistry.register(SpawnPacketListener.class);
        this.listenerRegistry.register(SpawnPulseListener.class);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey key) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((SpawnMetadata.SpawnMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)SpawnMetadata.builder().sender(fPlayer)).filterPlayer(fPlayer)).format(spawn -> key == MinecraftTranslationKey.BLOCK_MINECRAFT_SET_SPAWN ? spawn.getSet() : spawn.getNotValid())).destination(this.message.getDestination())).translationKey(key)).sound(this.getModuleSound())).build());
    }

    @Async
    public void send(FPlayer fPlayer, MinecraftTranslationKey key, Spawn spawn) {
        boolean isSingle;
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FPlayer fTarget = fPlayer;
        boolean bl = isSingle = key == MinecraftTranslationKey.COMMANDS_SPAWNPOINT_SUCCESS_SINGLE || key == MinecraftTranslationKey.COMMANDS_SPAWNPOINT_SUCCESS;
        if (isSingle && (fTarget = this.fPlayerService.getFPlayer(spawn.value())).isUnknown()) {
            return;
        }
        this.sendMessage(((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)((SpawnMetadata.SpawnMetadataBuilder)SpawnMetadata.builder().sender(fTarget)).filterPlayer(fPlayer)).format(s -> StringUtils.replaceEach((String)(isSingle ? s.getSingle() : s.getMultiple()), (String[])new String[]{"<count>", "<x>", "<y>", "<z>", "<angle>", "<world>"}, (String[])new String[]{spawn.value(), spawn.x(), spawn.y(), spawn.z(), spawn.angle(), spawn.world()}))).spawn(spawn)).translationKey(key)).destination(this.message.getDestination())).sound(this.getModuleSound())).build());
    }
}

