/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.spawn.extractor;

import java.util.List;
import java.util.Optional;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.event.message.MessageReceiveEvent;
import net.flectone.pulse.module.message.spawn.model.Spawn;
import net.flectone.pulse.processing.extractor.Extractor;
import net.flectone.pulse.util.constant.MinecraftTranslationKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;

@Singleton
public class SpawnExtractor
extends Extractor {
    @Inject
    public SpawnExtractor() {
    }

    public Optional<Spawn> extract(MessageReceiveEvent event) {
        Component zComponent;
        Component yComponent;
        Component xComponent;
        Component targetComponent;
        TranslatableComponent translatableComponent = event.getTranslatableComponent();
        List<Component> translationArguments = translatableComponent.args();
        if (translationArguments.size() < 4) {
            return Optional.empty();
        }
        String angle = "";
        String world = "";
        if (event.getTranslationKey() == MinecraftTranslationKey.COMMANDS_SPAWNPOINT_SUCCESS) {
            targetComponent = translationArguments.get(0);
            xComponent = translationArguments.get(1);
            yComponent = translationArguments.get(2);
            zComponent = translationArguments.get(3);
        } else {
            Component component;
            xComponent = translationArguments.get(0);
            yComponent = translationArguments.get(1);
            zComponent = translationArguments.get(2);
            targetComponent = translationArguments.getLast();
            if (translationArguments.size() >= 5 && (component = translationArguments.get(3)) instanceof TextComponent) {
                TextComponent angleComponent = (TextComponent)component;
                angle = angleComponent.content();
            }
            if (translationArguments.size() >= 6 && (component = translationArguments.get(4)) instanceof TextComponent) {
                TextComponent worldComponent = (TextComponent)component;
                world = worldComponent.content();
            }
        }
        if (!(xComponent instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent xComp = (TextComponent)xComponent;
        if (!(yComponent instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent yComp = (TextComponent)yComponent;
        if (!(zComponent instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent zComp = (TextComponent)zComponent;
        if (!(targetComponent instanceof TextComponent)) {
            return Optional.empty();
        }
        TextComponent tgtComp = (TextComponent)targetComponent;
        String x = xComp.content();
        String y = yComp.content();
        String z = zComp.content();
        String value = this.extractTarget(tgtComp);
        Spawn spawn = new Spawn(x, y, z, angle, world, value);
        return Optional.of(spawn);
    }
}

