/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.motd;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class MOTDModule
extends AbstractModuleListLocalization<Localization.Message.Status.MOTD> {
    private final Message.Status.MOTD message;
    private final Permission.Message.Status.MOTD permission;
    private final MessagePipeline messagePipeline;
    private final PacketProvider packetProvider;

    @Inject
    public MOTDModule(FileResolver fileResolver, MessagePipeline messagePipeline, PacketProvider packetProvider) {
        super(localization -> localization.getMessage().getStatus().getMotd(), MessageType.MOTD);
        this.message = fileResolver.getMessage().getStatus().getMotd();
        this.permission = fileResolver.getPermission().getMessage().getStatus().getMotd();
        this.messagePipeline = messagePipeline;
        this.packetProvider = packetProvider;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
    }

    public JsonElement next(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        String nextMessage = this.getNextMessage(fPlayer, this.message.isRandom());
        if (nextMessage == null) {
            return null;
        }
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
            return this.messagePipeline.builder(fPlayer, nextMessage).jsonSerializerBuild();
        }
        String serializedText = this.messagePipeline.builder(fPlayer, nextMessage).legacySerializerBuild();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", serializedText);
        return jsonObject;
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return ((Localization.Message.Status.MOTD)this.resolveLocalization(fPlayer)).getValues();
    }
}

