/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.players;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.status.players.listener.PlayersPulseListener;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class PlayersModule
extends AbstractModuleLocalization<Localization.Message.Status.Players> {
    private final Message.Status.Players message;
    private final Permission.Message.Status.Players permission;
    private final PermissionChecker permissionChecker;
    private final PlatformServerAdapter platformServerAdapter;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public PlayersModule(FileResolver fileResolver, PermissionChecker permissionChecker, PlatformServerAdapter platformServerAdapter, ListenerRegistry listenerRegistry) {
        super(module -> module.getMessage().getStatus().getPlayers(), MessageType.PLAYERS);
        this.message = fileResolver.getMessage().getStatus().getPlayers();
        this.permission = fileResolver.getPermission().getMessage().getStatus().getPlayers();
        this.permissionChecker = permissionChecker;
        this.platformServerAdapter = platformServerAdapter;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.registerPermission(this.permission.getBypass());
        this.listenerRegistry.register(PlayersPulseListener.class);
    }

    public boolean isAllowed(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return true;
        }
        if (!this.message.isControl()) {
            return true;
        }
        if (this.isModuleDisabledFor(fPlayer)) {
            return true;
        }
        if (this.permissionChecker.check((FEntity)fPlayer, this.permission.getBypass())) {
            return true;
        }
        int online = this.platformServerAdapter.getOnlinePlayerCount();
        return online < this.message.getMax();
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public List<Localization.Message.Status.Players.Sample> getSamples(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return ((Localization.Message.Status.Players)this.resolveLocalization(fPlayer)).getSamples();
    }

    @Generated
    public Message.Status.Players getMessage() {
        return this.message;
    }
}

