/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status.version;

import lombok.Generated;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class VersionModule
extends AbstractModuleLocalization<Localization.Message.Status.Version> {
    private final Message.Status.Version message;
    private final Permission.Message.Status.Version permission;

    @Inject
    public VersionModule(FileResolver fileResolver) {
        super(module -> module.getMessage().getStatus().getVersion(), MessageType.VERSION);
        this.message = fileResolver.getMessage().getStatus().getVersion();
        this.permission = fileResolver.getPermission().getMessage().getStatus().getVersion();
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    public String get(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return ((Localization.Message.Status.Version)this.resolveLocalization(fPlayer)).getName();
    }

    @Generated
    public Message.Status.Version getMessage() {
        return this.message;
    }
}

