/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.tab.footer;

import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerListHeaderAndFooter;
import java.util.List;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.module.message.tab.footer.listener.FooterPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;

@Singleton
public class FooterModule
extends AbstractModuleListLocalization<Localization.Message.Tab.Footer> {
    private final Message.Tab.Footer message;
    private final Permission.Message.Tab.Footer permission;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final ListenerRegistry listenerRegistry;
    private final PacketSender packetSender;

    @Inject
    public FooterModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, ListenerRegistry listenerRegistry, PacketSender packetSender) {
        super(module -> module.getMessage().getTab().getFooter(), MessageType.FOOTER);
        this.message = fileResolver.getMessage().getTab().getFooter();
        this.permission = fileResolver.getPermission().getMessage().getTab().getFooter();
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.listenerRegistry = listenerRegistry;
        this.packetSender = packetSender;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        Ticker ticker = this.message.getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::send), ticker.getPeriod());
        }
        this.listenerRegistry.register(FooterPulseListener.class);
    }

    @Override
    public void onDisable() {
        Destination.Type destinationType = this.message.getDestination().getType();
        if (destinationType == Destination.Type.TAB_HEADER || destinationType == Destination.Type.TAB_FOOTER) {
            this.packetSender.send((PacketWrapper<?>)new WrapperPlayServerPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty()));
        }
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String format = this.getNextMessage(fPlayer, this.message.isRandom());
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).destination(this.message.getDestination())).build());
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return this.joinMultiList(((Localization.Message.Tab.Footer)this.resolveLocalization(fPlayer)).getLists());
    }
}

