/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.tab.header.listener;

import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.module.message.tab.header.HeaderModule;

@Singleton
public class HeaderPulseListener
implements PulseListener {
    private final HeaderModule headerModule;

    @Inject
    public HeaderPulseListener(HeaderModule headerModule) {
        this.headerModule = headerModule;
    }

    @Pulse
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.headerModule.send(fPlayer);
    }

    @Pulse
    public void onPlayerLoadEvent(PlayerLoadEvent event) {
        if (!event.isReload()) {
            return;
        }
        FPlayer fPlayer = event.getPlayer();
        this.headerModule.send(fPlayer);
    }
}

