/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.tab.playerlist;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.tab.playerlist.listener.PlayerlistnamePulseListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;

@Singleton
public class PlayerlistnameModule
extends AbstractModuleLocalization<Localization.Message.Tab.Playerlistname> {
    private final Message.Tab.Playerlistname message;
    private final Permission.Message.Tab.Playerlistname permission;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final MessagePipeline messagePipeline;
    private final PacketSender packetSender;
    private final PacketProvider packetProvider;
    private final TaskScheduler taskScheduler;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public PlayerlistnameModule(FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, FileResolver fileResolver, MessagePipeline messagePipeline, PacketSender packetSender, PacketProvider packetProvider, TaskScheduler taskScheduler, ListenerRegistry listenerRegistry) {
        super(module -> module.getMessage().getTab().getPlayerlistname(), MessageType.PLAYERLISTNAME);
        this.message = fileResolver.getMessage().getTab().getPlayerlistname();
        this.permission = fileResolver.getPermission().getMessage().getTab().getPlayerlistname();
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.messagePipeline = messagePipeline;
        this.packetSender = packetSender;
        this.packetProvider = packetProvider;
        this.taskScheduler = taskScheduler;
        this.listenerRegistry = listenerRegistry;
    }

    @Override
    public void onEnable() {
        this.registerModulePermission(this.permission);
        this.fPlayerService.getPlatformFPlayers().forEach(this::send);
        Ticker ticker = this.message.getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::send), ticker.getPeriod());
        }
        this.listenerRegistry.register(PlayerlistnamePulseListener.class);
    }

    @Async
    public void update() {
        if (!this.isEnable()) {
            return;
        }
        this.fPlayerService.getPlatformFPlayers().forEach(this::send);
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!this.platformPlayerAdapter.isOnline(fPlayer)) {
            return;
        }
        this.fPlayerService.getFPlayersWhoCanSee(fPlayer).forEach(fReceiver -> this.updatePlayerlistname(fPlayer, (FPlayer)fReceiver));
    }

    @Override
    protected boolean isConfigEnable() {
        return this.message.isEnable();
    }

    private void updatePlayerlistname(FPlayer fPlayer, FPlayer fReceiver) {
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        Component name = this.messagePipeline.builder(fPlayer, fReceiver, ((Localization.Message.Tab.Playerlistname)this.resolveLocalization(fReceiver)).getFormat()).build();
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_4)) {
            WrapperPlayServerPlayerInfoUpdate.PlayerInfo playerInfo = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(user.getProfile(), true, this.fPlayerService.getPing(fPlayer), this.platformPlayerAdapter.getGamemode(fPlayer), name, null);
            this.packetSender.send(fReceiver, (PacketWrapper<?>)new WrapperPlayServerPlayerInfoUpdate(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME, new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{playerInfo}));
            return;
        }
        WrapperPlayServerPlayerInfo.PlayerData playerData = new WrapperPlayServerPlayerInfo.PlayerData(name, user.getProfile(), this.platformPlayerAdapter.getGamemode(fPlayer), this.fPlayerService.getPing(fPlayer));
        this.packetSender.send(fReceiver, (PacketWrapper<?>)new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.UPDATE_DISPLAY_NAME, new WrapperPlayServerPlayerInfo.PlayerData[]{playerData}));
    }
}

