/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.adapter;

import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.potion.PotionType;
import com.github.retrooper.packetevents.protocol.world.Location;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.flectone.pulse.FabricFlectonePulse;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.objective.ObjectiveModule;
import net.flectone.pulse.module.message.tab.footer.FooterModule;
import net.flectone.pulse.module.message.tab.header.HeaderModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class FabricPlayerAdapter
implements PlatformPlayerAdapter {
    private final FabricFlectonePulse fabricFlectonePulse;
    private final PacketProvider packetProvider;
    private final Injector injector;

    @Inject
    public FabricPlayerAdapter(FabricFlectonePulse fabricFlectonePulse, PacketProvider packetProvider, Injector injector) {
        this.fabricFlectonePulse = fabricFlectonePulse;
        this.packetProvider = packetProvider;
        this.injector = injector;
    }

    @Override
    public int getEntityId(@NotNull UUID uuid) {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return 0;
        }
        for (class_3218 world : minecraftServer.method_3738()) {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null) continue;
            return entity.method_5628();
        }
        return 0;
    }

    @Override
    @Nullable
    public UUID getPlayerByEntityId(int entityId) {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return null;
        }
        return minecraftServer.method_3760().method_14571().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5628() == entityId).findAny().map(class_1297::method_5667).orElse(null);
    }

    @Override
    @Nullable
    public UUID getUUID(@NotNull Object platformPlayer) {
        Object object = platformPlayer;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3222.class, class_2168.class}, (Object)object2, n)) {
            case 0 -> {
                class_3222 player = (class_3222)object2;
                yield player.method_5667();
            }
            case 1 -> {
                class_2168 commandSource = (class_2168)object2;
                class_3222 player = commandSource.method_44023();
                if (player == null) {
                    yield null;
                }
                yield player.method_5667();
            }
            default -> null;
        };
    }

    @Override
    @Nullable
    public Object convertToPlatformPlayer(@NotNull FPlayer fPlayer) {
        return this.getPlayer(fPlayer.getUuid());
    }

    @Override
    @Nullable
    public Object convertToPlatformPlayer(@NotNull UUID uuid) {
        return this.getPlayer(uuid);
    }

    @Override
    @NotNull
    public String getName(@NotNull UUID uuid) {
        class_3222 player = this.getPlayer(uuid);
        if (player == null) {
            return "";
        }
        return player.method_5477().getString();
    }

    @Override
    @NotNull
    public String getName(@NotNull Object platformPlayer) {
        Object object = platformPlayer;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3222.class, class_2168.class}, (Object)object2, n)) {
            case 0 -> {
                class_3222 player = (class_3222)object2;
                yield player.method_5477().getString();
            }
            case 1 -> {
                class_2168 commandSource = (class_2168)object2;
                yield commandSource.method_9214();
            }
            default -> "";
        };
    }

    @Override
    @NotNull
    public String getWorldName(@NotNull FPlayer fPlayer) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player == null) {
            return "";
        }
        return player.method_51469().method_27983().method_29177().method_12832();
    }

    @Override
    @NotNull
    public String getWorldEnvironment(@NotNull FPlayer fPlayer) {
        return this.getWorldName(fPlayer);
    }

    @Override
    @Nullable
    public String getIp(@NotNull FPlayer fPlayer) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player != null) {
            return player.method_14209();
        }
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return null;
        }
        return this.packetProvider.getHostAddress(user.getAddress());
    }

    @Override
    @NotNull
    public GameMode getGamemode(@NotNull FPlayer fPlayer) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player == null) {
            return GameMode.SURVIVAL;
        }
        return GameMode.getById((int)player.method_68876().method_8379());
    }

    @Override
    @NotNull
    public Component getPlayerListHeader(@NotNull FPlayer fPlayer) {
        String header;
        HeaderModule headerModule = (HeaderModule)this.injector.getInstance(HeaderModule.class);
        if (!headerModule.isModuleDisabledFor(fPlayer) && (header = headerModule.getCurrentMessage(fPlayer)) != null) {
            return ((MessagePipeline)this.injector.getInstance(MessagePipeline.class)).builder(fPlayer, header).build();
        }
        return Component.empty();
    }

    @Override
    @NotNull
    public Component getPlayerListFooter(@NotNull FPlayer fPlayer) {
        String footer;
        FooterModule footerModule = (FooterModule)this.injector.getInstance(FooterModule.class);
        if (!footerModule.isModuleDisabledFor(fPlayer) && (footer = footerModule.getCurrentMessage(fPlayer)) != null) {
            return ((MessagePipeline)this.injector.getInstance(MessagePipeline.class)).builder(fPlayer, footer).build();
        }
        return Component.empty();
    }

    @Override
    public int getObjectiveScore(@NotNull UUID uuid, @Nullable ObjectiveModule.Mode mode) {
        if (mode == null) {
            return 0;
        }
        class_3222 player = this.getPlayer(uuid);
        if (player == null) {
            return 0;
        }
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case ObjectiveModule.Mode.HEALTH -> (int)Math.round((double)player.method_6032() * 10.0) / 10;
            case ObjectiveModule.Mode.LEVEL -> player.field_7520;
            case ObjectiveModule.Mode.FOOD -> player.method_7344().method_7586();
            case ObjectiveModule.Mode.PING -> this.packetProvider.getPlayerManager().getPing((Object)player);
            case ObjectiveModule.Mode.ARMOR -> player.method_6096();
            case ObjectiveModule.Mode.ATTACK -> player.method_6047().method_7919();
        };
    }

    @Override
    @Nullable
    public PlatformPlayerAdapter.Statistics getStatistics(@NotNull FEntity fEntity) {
        class_3222 player = this.getPlayer(fEntity.getUuid());
        if (player == null) {
            return null;
        }
        return new PlatformPlayerAdapter.Statistics(Math.round((double)player.method_6032() * 10.0), player.method_6096(), player.field_7520, player.method_7344().method_7586(), player.method_6047().method_7919());
    }

    @Override
    @Nullable
    public PlatformPlayerAdapter.Coordinates getCoordinates(@NotNull FEntity fEntity) {
        class_3222 player = this.getPlayer(fEntity.getUuid());
        if (player == null) {
            return null;
        }
        return new PlatformPlayerAdapter.Coordinates(player.method_31477(), player.method_31478(), player.method_31479());
    }

    @Override
    @Nullable
    public Location getLocation(@NotNull FPlayer fPlayer) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player == null) {
            return null;
        }
        return new Location(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
    }

    @Override
    public double distance(@NotNull FPlayer first, @NotNull FPlayer second) {
        if (first.equals(second)) {
            return 0.0;
        }
        class_3222 firstPlayer = this.getPlayer(first.getUuid());
        if (firstPlayer == null) {
            return -1.0;
        }
        class_3222 secondPlayer = this.getPlayer(second.getUuid());
        if (secondPlayer == null) {
            return -1.0;
        }
        if (!firstPlayer.method_51469().equals(secondPlayer.method_51469())) {
            return -1.0;
        }
        return firstPlayer.method_5739((class_1297)secondPlayer);
    }

    @Override
    public boolean isConsole(@NotNull Object platformPlayer) {
        class_2168 source;
        return platformPlayer instanceof class_2168 && (source = (class_2168)platformPlayer).method_9228() == null && source.method_9211().method_3816();
    }

    @Override
    public boolean hasPlayedBefore(@NotNull FPlayer fPlayer) {
        return true;
    }

    @Override
    public boolean hasPotionEffect(@NotNull FEntity fPlayer, @NotNull PotionType potionType) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player == null) {
            return false;
        }
        ClientVersion clientVersion = this.packetProvider.getServerVersion().toClientVersion();
        Optional statusEffect = class_7923.field_41174.method_40265(potionType.getId(clientVersion));
        return statusEffect.filter(arg_0 -> ((class_3222)player).method_6059(arg_0)).isPresent();
    }

    @Override
    public boolean isOnline(@NotNull FPlayer fPlayer) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        return player != null;
    }

    @Override
    public long getFirstPlayed(@NotNull FPlayer fPlayer) {
        return 0L;
    }

    @Override
    public long getLastPlayed(@NotNull FPlayer fPlayer) {
        return 0L;
    }

    @Override
    public long getAllTimePlayed(@NotNull FPlayer fPlayer) {
        return 0L;
    }

    @Override
    public void updateInventory(@NotNull UUID uuid) {
        class_3222 player = this.getPlayer(uuid);
        if (player == null) {
            return;
        }
        player.method_31548().method_7381();
    }

    @Override
    @Nullable
    public Object getItem(@NotNull UUID uuid) {
        class_3222 player = this.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return player.method_6047();
    }

    @Override
    @NotNull
    public List<UUID> getOnlinePlayers() {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return Collections.emptyList();
        }
        return minecraftServer.method_3760().method_14571().stream().map(class_1297::method_5667).toList();
    }

    @Override
    @NotNull
    public Set<UUID> findPlayersWhoCanSee(FPlayer fPlayer, double x, double y, double z) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player == null) {
            return Collections.emptySet();
        }
        class_243 position = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
        class_238 searchBox = new class_238(position.method_1023(x, y, z), position.method_1031(x, y, z));
        return player.method_51469().method_8390(class_3222.class, searchBox, entity -> true).stream().filter(target -> {
            class_3965 hitResult = target.method_51469().method_17742(new class_3959(target.method_5836(1.0f), player.method_5836(1.0f), class_3959.class_3960.field_23142, class_3959.class_242.field_1345, (class_1297)target));
            return hitResult.method_17783() == class_239.class_240.field_1333;
        }).map(class_1297::method_5667).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public List<Integer> getPassengers(FPlayer fPlayer) {
        class_3222 player = this.getPlayer(fPlayer.getUuid());
        if (player == null) {
            return Collections.emptyList();
        }
        return player.method_5685().stream().map(class_1297::method_5628).toList();
    }

    @Override
    @NotNull
    public List<PlatformPlayerAdapter.PlayedTimePlayer> getPlayedTimePlayers() {
        return Collections.emptyList();
    }

    @Nullable
    public class_3222 getPlayer(UUID uuid) {
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return null;
        }
        class_3324 playerManager = minecraftServer.method_3760();
        if (playerManager == null) {
            return null;
        }
        return playerManager.method_14602(uuid);
    }
}

