/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.adapter;

import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.potion.PotionType;
import com.github.retrooper.packetevents.protocol.world.Location;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.objective.ObjectiveModule;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformPlayerAdapter {
    public int getEntityId(@NotNull UUID var1);

    @Nullable
    public UUID getPlayerByEntityId(int var1);

    @Nullable
    public UUID getUUID(@NotNull Object var1);

    @Nullable
    public Object convertToPlatformPlayer(@NotNull FPlayer var1);

    @Nullable
    public Object convertToPlatformPlayer(@NotNull UUID var1);

    @NotNull
    public String getName(@NotNull UUID var1);

    @NotNull
    public String getName(@NotNull Object var1);

    @NotNull
    public String getWorldName(@NotNull FPlayer var1);

    @NotNull
    public String getWorldEnvironment(@NotNull FPlayer var1);

    @Nullable
    public String getIp(@NotNull FPlayer var1);

    @NotNull
    public GameMode getGamemode(@NotNull FPlayer var1);

    @NotNull
    public Component getPlayerListHeader(@NotNull FPlayer var1);

    @NotNull
    public Component getPlayerListFooter(@NotNull FPlayer var1);

    public int getObjectiveScore(@NotNull UUID var1, @Nullable ObjectiveModule.Mode var2);

    @Nullable
    public Statistics getStatistics(@NotNull FEntity var1);

    @Nullable
    public Coordinates getCoordinates(@NotNull FEntity var1);

    @Nullable
    public Location getLocation(@NotNull FPlayer var1);

    public double distance(@NotNull FPlayer var1, @NotNull FPlayer var2);

    public boolean isConsole(@NotNull Object var1);

    public boolean hasPlayedBefore(@NotNull FPlayer var1);

    public boolean hasPotionEffect(@NotNull FEntity var1, @NotNull PotionType var2);

    public boolean isOnline(@NotNull FPlayer var1);

    public long getFirstPlayed(@NotNull FPlayer var1);

    public long getLastPlayed(@NotNull FPlayer var1);

    public long getAllTimePlayed(@NotNull FPlayer var1);

    public void updateInventory(@NotNull UUID var1);

    @Nullable
    public Object getItem(@NotNull UUID var1);

    @NotNull
    public List<UUID> getOnlinePlayers();

    @NotNull
    public Set<UUID> findPlayersWhoCanSee(FPlayer var1, double var2, double var4, double var6);

    @NotNull
    public List<Integer> getPassengers(FPlayer var1);

    @NotNull
    public List<PlayedTimePlayer> getPlayedTimePlayers();

    public record PlayedTimePlayer(String name, long playedTime) {
    }

    public record Statistics(double health, double armor, double level, double food, double damage) {
    }

    public record Coordinates(double x, double y, double z) {
    }
}

