/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.controller;

import com.github.retrooper.packetevents.protocol.dialog.MultiActionDialog;
import com.github.retrooper.packetevents.protocol.dialog.action.Action;
import com.github.retrooper.packetevents.protocol.dialog.action.DynamicCustomAction;
import com.github.retrooper.packetevents.protocol.dialog.button.ActionButton;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerClearDialog;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerShowDialog;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.dialog.Dialog;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.platform.sender.PacketSender;

@Singleton
public class DialogController {
    private final Map<UUID, Dialog> dialogMap = new ConcurrentHashMap<UUID, Dialog>();
    private final PacketSender packetSender;

    @Inject
    public DialogController(PacketSender packetSender) {
        this.packetSender = packetSender;
    }

    public Dialog get(UUID uuid) {
        return this.dialogMap.get(uuid);
    }

    public void close(UUID uuid) {
        Dialog dialog = this.dialogMap.get(uuid);
        if (dialog == null) {
            return;
        }
        dialog.getCloseConsumerList().forEach(closeConsumer -> closeConsumer.accept(dialog));
        this.dialogMap.remove(uuid);
    }

    public void closeAll() {
        WrapperPlayServerClearDialog wrapper = new WrapperPlayServerClearDialog();
        this.dialogMap.keySet().forEach(uuid -> this.packetSender.send((UUID)uuid, (PacketWrapper<?>)wrapper));
        this.dialogMap.clear();
    }

    public void open(FPlayer fPlayer, Dialog dialog, boolean reopen) {
        Dialog oldDialog;
        if (reopen && (oldDialog = this.dialogMap.get(fPlayer.getUuid())) != null) {
            oldDialog.getCloseConsumerList().forEach(closeConsumer -> closeConsumer.accept(oldDialog));
        }
        this.dialogMap.put(fPlayer.getUuid(), dialog);
        this.packetSender.send(fPlayer, (PacketWrapper<?>)dialog.getWrapperDialog());
    }

    public void click(Dialog dialog, String key, NBT payload) {
        if (!dialog.getClickConsumerMap().containsKey(key)) {
            return;
        }
        dialog.getClickConsumerMap().get(key).accept(dialog, payload);
    }

    @Async
    public void process(UUID uuid, String key, NBT payload) {
        Dialog dialog = this.get(uuid);
        if (dialog == null) {
            return;
        }
        this.click(dialog, key, payload);
    }

    public void changeButton(FPlayer fPlayer, Dialog dialog, String id, ActionButton actionButton) {
        com.github.retrooper.packetevents.protocol.dialog.Dialog dialog2;
        WrapperPlayServerShowDialog showDialog = dialog.getWrapperDialog();
        if (showDialog == null || !((dialog2 = showDialog.getDialog()) instanceof MultiActionDialog)) {
            return;
        }
        MultiActionDialog multiActionDialog = (MultiActionDialog)dialog2;
        ArrayList<ActionButton> actionButtons = new ArrayList<ActionButton>(multiActionDialog.getActions());
        for (int i = 0; i < actionButtons.size(); ++i) {
            DynamicCustomAction dynamicCustomAction;
            ActionButton button = (ActionButton)actionButtons.get(i);
            Action action = button.getAction();
            if (!(action instanceof DynamicCustomAction) || !(dynamicCustomAction = (DynamicCustomAction)action).getId().getKey().equals(id)) continue;
            actionButtons.set(i, actionButton);
            break;
        }
        MultiActionDialog newMultiActionDialog = new MultiActionDialog(multiActionDialog.getCommon(), actionButtons, multiActionDialog.getExitAction(), multiActionDialog.getColumns());
        dialog.setWrapperDialog(new WrapperPlayServerShowDialog((com.github.retrooper.packetevents.protocol.dialog.Dialog)newMultiActionDialog));
        this.open(fPlayer, dialog, true);
    }
}

