/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.formatter;

import java.net.URI;
import java.net.URISyntaxException;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;

@Singleton
public class UrlFormatter {
    private final String safeAmpersand = "__AND__";

    @Inject
    public UrlFormatter() {
    }

    public String escapeAmpersand(String url) {
        return Strings.CS.replace(url, "&", "__AND__");
    }

    public String unescapeAmpersand(String url) {
        return Strings.CS.replace(url, "__AND__", "&");
    }

    public String toASCII(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        try {
            return new URI(this.unescapeAmpersand(url)).toASCIIString();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }
}

