/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.provider;

import io.leangen.geantyref.TypeToken;
import java.time.Duration;
import java.util.Collections;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.processing.parser.integer.ColorParser;
import net.flectone.pulse.processing.parser.integer.DurationReasonParser;
import net.flectone.pulse.processing.parser.moderation.BanModerationParser;
import net.flectone.pulse.processing.parser.moderation.MuteModerationParser;
import net.flectone.pulse.processing.parser.moderation.WarnModerationParser;
import net.flectone.pulse.processing.parser.player.OfflinePlayerParser;
import net.flectone.pulse.processing.parser.player.PlatformPlayerParser;
import net.flectone.pulse.processing.parser.player.PlayerParser;
import net.flectone.pulse.processing.parser.string.MessageParser;
import net.flectone.pulse.processing.parser.string.SingleMessageParser;
import net.flectone.pulse.util.checker.PermissionChecker;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.standard.BooleanParser;
import org.incendo.cloud.parser.standard.DurationParser;
import org.incendo.cloud.parser.standard.IntegerParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.incendo.cloud.type.tuple.Pair;

@Singleton
public class CommandParserProvider {
    private final PermissionChecker permissionChecker;
    private final PlayerParser playerParser;
    private final PlatformPlayerParser platformPlayerParser;
    private final OfflinePlayerParser offlinePlayerParser;
    private final DurationReasonParser durationReasonParser;
    private final BanModerationParser banModerationParser;
    private final MuteModerationParser muteModerationParser;
    private final WarnModerationParser warnModerationParser;
    private final ColorParser colorParser;
    private final MessageParser messageParser;
    private final SingleMessageParser singleMessageParser;
    private final StringParser<FPlayer> singleStringParser = new StringParser(StringParser.StringMode.SINGLE);
    private final StringParser<FPlayer> greedyStringParser = new StringParser(StringParser.StringMode.GREEDY);
    private final IntegerParser<FPlayer> integerParser = new IntegerParser(0, Integer.MAX_VALUE);
    private final BooleanParser<FPlayer> booleanParser = new BooleanParser(false);
    private final DurationParser<FPlayer> durationParser = new DurationParser();

    @Inject
    public CommandParserProvider(PermissionChecker permissionChecker, PlayerParser playerParser, PlatformPlayerParser platformPlayerParser, OfflinePlayerParser offlinePlayerParser, DurationReasonParser durationReasonParser, BanModerationParser banModerationParser, MuteModerationParser muteModerationParser, WarnModerationParser warnModerationParser, ColorParser colorParser, MessageParser messageParser, SingleMessageParser singleMessageParser) {
        this.permissionChecker = permissionChecker;
        this.banModerationParser = banModerationParser;
        this.muteModerationParser = muteModerationParser;
        this.warnModerationParser = warnModerationParser;
        this.playerParser = playerParser;
        this.platformPlayerParser = platformPlayerParser;
        this.offlinePlayerParser = offlinePlayerParser;
        this.durationReasonParser = durationReasonParser;
        this.colorParser = colorParser;
        this.messageParser = messageParser;
        this.singleMessageParser = singleMessageParser;
    }

    public @NonNull ParserDescriptor<FPlayer, String> playerParser(boolean offlinePlayers) {
        return offlinePlayers ? this.offlinePlayerParser() : this.playerParser();
    }

    public @NonNull ParserDescriptor<FPlayer, String> offlinePlayerParser() {
        return ParserDescriptor.of((ArgumentParser)this.offlinePlayerParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> playerParser() {
        return ParserDescriptor.of((ArgumentParser)this.playerParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> platformPlayerParser() {
        return ParserDescriptor.of((ArgumentParser)this.platformPlayerParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, Integer> integerParser() {
        return ParserDescriptor.of(this.integerParser, Integer.class);
    }

    public @NonNull ParserDescriptor<FPlayer, Boolean> booleanParser() {
        return ParserDescriptor.of(this.booleanParser, Boolean.class);
    }

    public @NonNull ParserDescriptor<FPlayer, Integer> integerParser(int min, int max) {
        return ParserDescriptor.of((ArgumentParser)new IntegerParser(min, max), Integer.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> nativeSingleMessageParser() {
        return ParserDescriptor.of(this.singleStringParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> nativeMessageParser() {
        return ParserDescriptor.of(this.greedyStringParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> messageParser() {
        return ParserDescriptor.of((ArgumentParser)this.messageParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> singleMessageParser() {
        return ParserDescriptor.of((ArgumentParser)this.singleMessageParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> bannedParser() {
        return ParserDescriptor.of((ArgumentParser)this.banModerationParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> mutedParser() {
        return ParserDescriptor.of((ArgumentParser)this.muteModerationParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> warnedParser() {
        return ParserDescriptor.of((ArgumentParser)this.warnModerationParser, String.class);
    }

    public @NonNull ParserDescriptor<FPlayer, Pair<Long, String>> durationReasonParser() {
        return ParserDescriptor.of((ArgumentParser)this.durationReasonParser, (TypeToken)new TypeToken<Pair<Long, String>>(this){});
    }

    public @NonNull ParserDescriptor<FPlayer, Duration> durationParser() {
        return ParserDescriptor.of(this.durationParser, Duration.class);
    }

    public @NonNull ParserDescriptor<FPlayer, String> colorParser() {
        return ParserDescriptor.of((ArgumentParser)this.colorParser, String.class);
    }

    public @NonNull BlockingSuggestionProvider<FPlayer> playerSuggestionPermission(boolean offlinePlayers, Permission.IPermission permission) {
        return (context, input) -> {
            if (!this.permissionChecker.check((FEntity)context.sender(), permission)) {
                return Collections.emptyList();
            }
            return (Iterable)this.playerParser(offlinePlayers).parser().suggestionProvider().suggestionsFuture(context, input).join();
        };
    }
}

