/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.provider;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.EventManager;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import org.jetbrains.annotations.Nullable;

@Singleton
public class PacketProvider {
    private final PacketEventsAPI<?> api = PacketEvents.getAPI();

    @Inject
    public PacketProvider() {
    }

    public EventManager getEventManager() {
        return this.api.getEventManager();
    }

    public ProtocolManager getProtocolManager() {
        return this.api.getProtocolManager();
    }

    public PlayerManager getPlayerManager() {
        return this.api.getPlayerManager();
    }

    public Object getChannel(UUID uuid) {
        return this.getProtocolManager().getChannel(uuid);
    }

    public User getUser(UUID uuid) {
        Object channel = this.getChannel(uuid);
        if (channel == null) {
            return null;
        }
        return this.getProtocolManager().getUser(channel);
    }

    public User getUser(FPlayer fPlayer) {
        return this.getUser(fPlayer.getUuid());
    }

    public int getPing(Object player) {
        return this.getPlayerManager().getPing(player);
    }

    public ServerVersion getServerVersion() {
        return this.api.getServerManager().getVersion();
    }

    @Nullable
    public String getHostAddress(@Nullable InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    @Generated
    public PacketEventsAPI<?> getApi() {
        return this.api;
    }
}

