/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.proxy;

import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.flectone.pulse.FabricFlectonePulse;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.guava.collect.Iterables;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.platform.handler.ProxyMessageHandler;
import net.flectone.pulse.platform.proxy.Proxy;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

@Singleton
public class FabricProxy
implements Proxy {
    private final Config config;
    private final FabricFlectonePulse fabricFlectonePulse;
    private final ProxyMessageHandler proxyMessageHandler;
    private class_8710.class_9154<ProxyPayload> channel;
    private class_9139<class_9129, ProxyPayload> packetCodec;

    @Inject
    public FabricProxy(FileResolver fileResolver, FabricFlectonePulse fabricFlectonePulse, ProxyMessageHandler proxyMessageHandler) {
        this.config = fileResolver.getConfig();
        this.fabricFlectonePulse = fabricFlectonePulse;
        this.proxyMessageHandler = proxyMessageHandler;
    }

    @Override
    public boolean isEnable() {
        return this.channel != null;
    }

    @Override
    public void onEnable() {
        String channelName = this.getChannel();
        if (channelName == null) {
            return;
        }
        this.channel = new class_8710.class_9154(class_2960.method_60654((String)channelName));
        if (this.packetCodec == null) {
            this.packetCodec = class_9139.method_56438((value, buf) -> buf.method_52983(value.data), buf -> {
                byte[] data = new byte[buf.readableBytes()];
                buf.method_52979(data);
                return new ProxyPayload(this.channel, data);
            });
            PayloadTypeRegistry.playC2S().register(this.channel, this.packetCodec);
            PayloadTypeRegistry.playS2C().register(this.channel, this.packetCodec);
        }
        ServerPlayNetworking.registerGlobalReceiver(this.channel, (payload, context) -> this.proxyMessageHandler.handleProxyMessage(payload.data()));
    }

    @Override
    public void onDisable() {
        if (!this.isEnable()) {
            return;
        }
        ServerPlayNetworking.unregisterGlobalReceiver((class_2960)this.channel.comp_2242());
        this.channel = null;
    }

    @Override
    public boolean sendMessage(FEntity sender, MessageType tag, byte[] message) {
        if (!this.isEnable()) {
            return false;
        }
        if (tag == null) {
            return false;
        }
        MinecraftServer minecraftServer = this.fabricFlectonePulse.getMinecraftServer();
        if (minecraftServer == null) {
            return false;
        }
        class_3222 player = minecraftServer.method_3760().method_14602(sender.getUuid());
        if (player == null) {
            player = (class_3222)Iterables.getFirst((Iterable)minecraftServer.method_3760().method_14571(), null);
        }
        if (player == null) {
            return false;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ProxyPayload(this.channel, message));
        return true;
    }

    @Nullable
    public String getChannel() {
        if (this.config.isBungeecord()) {
            return "bungeecord:main";
        }
        if (this.config.isVelocity()) {
            return "flectonepulse:main";
        }
        return null;
    }

    public record ProxyPayload(class_8710.class_9154<? extends class_8710> id, byte[] data) implements class_8710
    {
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return this.id;
        }
    }
}

