/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.proxy;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import java.nio.charset.StandardCharsets;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.RedisListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.platform.proxy.Proxy;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class RedisProxy
implements Proxy {
    private final Config.Redis config;
    private final Config.Database database;
    private final FLogger fLogger;
    private final Provider<RedisListener> redisListenerProvider;
    private final SystemVariableResolver systemVariableResolver;
    private RedisClient redisClient;
    private StatefulRedisPubSubConnection<byte[], byte[]> pubSubConnection;

    @Inject
    public RedisProxy(FileResolver fileResolver, FLogger fLogger, Provider<RedisListener> redisListenerProvider, SystemVariableResolver systemVariableResolver) {
        this.config = fileResolver.getConfig().getRedis();
        this.database = fileResolver.getConfig().getDatabase();
        this.fLogger = fLogger;
        this.redisListenerProvider = redisListenerProvider;
        this.systemVariableResolver = systemVariableResolver;
    }

    @Override
    public boolean isEnable() {
        return this.config.isEnable() && this.database.getType() == Database.Type.MYSQL && this.pubSubConnection != null && this.pubSubConnection.isOpen();
    }

    @Override
    public void onEnable() {
        if (this.pubSubConnection != null) {
            this.pubSubConnection.close();
        }
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(this.config.getHost()).withPort(this.config.getPort()).withSsl(this.config.isSsl());
        if (!this.config.getUser().isEmpty() && !this.config.getPassword().isEmpty()) {
            uriBuilder.withAuthentication(this.systemVariableResolver.substituteEnvVars(this.config.getUser()), (CharSequence)this.systemVariableResolver.substituteEnvVars(this.config.getPassword()));
        }
        this.redisClient = RedisClient.create((RedisURI)uriBuilder.build());
        this.pubSubConnection = this.redisClient.connectPubSub((RedisCodec)new ByteArrayCodec());
        try {
            this.pubSubConnection.sync().ping();
            this.fLogger.info("Redis (Lettuce) connected");
            RedisPubSubAsyncCommands async = this.pubSubConnection.async();
            for (MessageType tag : MessageType.values()) {
                async.subscribe((Object[])new byte[][]{tag.name().getBytes(StandardCharsets.UTF_8)});
            }
            this.pubSubConnection.addListener((RedisPubSubListener)this.redisListenerProvider.get());
        }
        catch (Exception e) {
            this.fLogger.warning("Redis connection failed: " + e.getMessage());
            this.onDisable();
        }
    }

    @Override
    public void onDisable() {
        if (this.pubSubConnection != null) {
            this.pubSubConnection.close();
        }
        if (this.redisClient != null) {
            this.redisClient.shutdown();
        }
    }

    @Override
    public boolean sendMessage(FEntity sender, MessageType tag, byte[] message) {
        if (!this.isEnable()) {
            return false;
        }
        if (tag == null) {
            return false;
        }
        this.pubSubConnection.async().publish((Object)tag.name().getBytes(StandardCharsets.UTF_8), (Object)message);
        return true;
    }
}

