/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import java.util.function.Function;
import net.flectone.pulse.FabricFlectonePulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.platform.handler.CommandExceptionHandler;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.processing.mapper.FPlayerMapper;
import net.flectone.pulse.util.checker.PermissionChecker;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;
import org.incendo.cloud.permission.Permission;
import org.incendo.cloud.permission.PermissionResult;
import org.incendo.cloud.setting.ManagerSetting;
import org.incendo.cloud.setting.Setting;

@Singleton
public class FabricCommandRegistry
extends CommandRegistry {
    private final FabricFlectonePulse fabricFlectonePulse;
    private final PermissionChecker permissionChecker;
    private final CommandManager<FPlayer> manager;

    @Inject
    public FabricCommandRegistry(FabricFlectonePulse fabricFlectonePulse, PermissionChecker permissionChecker, CommandExceptionHandler commandExceptionHandler, FPlayerMapper fPlayerMapper) {
        this.fabricFlectonePulse = fabricFlectonePulse;
        this.permissionChecker = permissionChecker;
        this.manager = new FabricServerCommandManager(ExecutionCoordinator.asyncCoordinator(), (SenderMapper)fPlayerMapper);
        this.manager.settings().set((Setting)ManagerSetting.ALLOW_UNSAFE_REGISTRATION, true);
        this.manager.settings().set((Setting)ManagerSetting.OVERRIDE_EXISTING_COMMANDS, true);
        this.manager.exceptionController().registerHandler(ArgumentParseException.class, commandExceptionHandler::handleArgumentParseException);
        this.manager.exceptionController().registerHandler(InvalidSyntaxException.class, commandExceptionHandler::handleInvalidSyntaxException);
        this.manager.exceptionController().registerHandler(NoPermissionException.class, commandExceptionHandler::handleNoPermissionException);
        this.manager.exceptionController().registerHandler(CommandExecutionException.class, commandExceptionHandler::handleCommandExecutionException);
    }

    @Override
    public final void registerCommand(Function<CommandManager<FPlayer>, Command.Builder<FPlayer>> builder) {
        Command.Builder<FPlayer> commandBuilder = builder.apply(this.manager);
        Permission permission = commandBuilder.commandPermission();
        String permissionString = permission.permissionString();
        Command command = commandBuilder.permission(fPlayer -> {
            boolean value = this.permissionChecker.check((FEntity)fPlayer, permissionString);
            return PermissionResult.of((boolean)value, (Permission)permission);
        }).build();
        String commandName = command.rootComponent().name();
        boolean isCloudCommand = this.manager.commands().stream().anyMatch(fPlayerCommand -> fPlayerCommand.rootComponent().name().equals(commandName));
        if (isCloudCommand) {
            return;
        }
        this.unregisterCommand(commandName);
        this.manager.command(command);
    }

    @Override
    public void unregisterCommand(String name) {
        if (this.fabricFlectonePulse.getMinecraftServer() != null) {
            return;
        }
        if (!this.manager.hasCapability((CloudCapability)CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION)) {
            return;
        }
        this.manager.deleteRootCommand(name);
    }

    @Override
    public void reload() {
    }
}

