/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import com.github.retrooper.packetevents.event.EventManager;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.BasePacketListener;
import net.flectone.pulse.listener.BasePulseListener;
import net.flectone.pulse.listener.DialogPacketListener;
import net.flectone.pulse.listener.InventoryPacketListener;
import net.flectone.pulse.listener.MessagePulseListener;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.Registry;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class ListenerRegistry
implements Registry {
    private final Map<Class<? extends Event>, EnumMap<Event.Priority, List<Consumer<Event>>>> pulseListeners = new ConcurrentHashMap<Class<? extends Event>, EnumMap<Event.Priority, List<Consumer<Event>>>>();
    private final List<PacketListenerCommon> packetListeners = new ArrayList<PacketListenerCommon>();
    private final FLogger fLogger;
    private final Injector injector;
    private final PacketProvider packetProvider;

    @Inject
    public ListenerRegistry(FLogger fLogger, Injector injector, PacketProvider packetProvider) {
        this.fLogger = fLogger;
        this.injector = injector;
        this.packetProvider = packetProvider;
    }

    public void register(Class<?> clazzListener) {
        this.register(clazzListener, Event.Priority.NORMAL);
    }

    public void register(Class<?> clazzListener, Event.Priority eventPriority) {
        if (PacketListener.class.isAssignableFrom(clazzListener)) {
            PacketListener packetListener = (PacketListener)this.injector.getInstance(clazzListener);
            this.register(packetListener, PacketListenerPriority.valueOf((String)eventPriority.name()));
            return;
        }
        if (PulseListener.class.isAssignableFrom(clazzListener)) {
            PulseListener pulseListener = (PulseListener)this.injector.getInstance(clazzListener);
            this.register(pulseListener);
        }
    }

    public void register(PacketListener packetListener, PacketListenerPriority priority) {
        PacketListenerCommon packetListenerCommon = this.packetProvider.getEventManager().registerListener(packetListener, priority);
        this.packetListeners.add(packetListenerCommon);
    }

    public void register(PulseListener pulseListener) {
        for (Method method : pulseListener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Pulse.class) || method.isBridge() || method.isSynthetic()) continue;
            Pulse annotation = method.getAnnotation(Pulse.class);
            this.registerAnnotatedMethod(pulseListener, method, annotation);
        }
    }

    private void registerAnnotatedMethod(PulseListener listener, Method method, Pulse annotation) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1 || !Event.class.isAssignableFrom(paramTypes[0])) {
            throw new IllegalArgumentException("@Pulse method must have single Event parameter: " + String.valueOf(method));
        }
        Class<?> eventClass = paramTypes[0];
        this.register(eventClass, annotation.priority(), event -> {
            if (event.isCancelled() && !annotation.ignoreCancelled()) {
                return;
            }
            try {
                method.invoke((Object)listener, event);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.fLogger.warning("Failed to invoke @Pulse handler");
                this.fLogger.warning(e);
            }
        });
    }

    public void register(Class<? extends Event> eventClass, Event.Priority priority, Consumer<Event> handler) {
        this.pulseListeners.computeIfAbsent(eventClass, k -> new EnumMap(Event.Priority.class)).computeIfAbsent(priority, k -> new CopyOnWriteArrayList()).add(handler);
    }

    public void unregisterAll() {
        EventManager eventManager = this.packetProvider.getEventManager();
        this.packetListeners.forEach(xva$0 -> eventManager.unregisterListeners(new PacketListenerCommon[]{xva$0}));
        this.packetListeners.clear();
        this.pulseListeners.clear();
    }

    @Override
    public void reload() {
        this.unregisterAll();
        this.registerDefaultListeners();
    }

    public void registerDefaultListeners() {
        this.register(BasePacketListener.class);
        this.register(BasePulseListener.class);
        this.register(MessagePulseListener.class);
        this.register(InventoryPacketListener.class);
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_6)) {
            this.register(DialogPacketListener.class);
        }
    }

    @Generated
    public Map<Class<? extends Event>, EnumMap<Event.Priority, List<Consumer<Event>>>> getPulseListeners() {
        return this.pulseListeners;
    }

    @Generated
    public List<PacketListenerCommon> getPacketListeners() {
        return this.packetListeners;
    }

    @Generated
    public FLogger getFLogger() {
        return this.fLogger;
    }

    @Generated
    public Injector getInjector() {
        return this.injector;
    }

    @Generated
    public PacketProvider getPacketProvider() {
        return this.packetProvider;
    }
}

