/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.apache.lang3.RegExUtils;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.chat.model.ChatMetadata;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

@Singleton
public class IntegrationSender {
    private final Pattern finalClearMessagePattern = Pattern.compile("[\\p{C}\\p{So}\\x{E0100}-\\x{E01EF}]+");
    private final IntegrationModule integrationModule;
    private final MessagePipeline messagePipeline;

    @Inject
    public IntegrationSender(IntegrationModule integrationModule, MessagePipeline messagePipeline) {
        this.integrationModule = integrationModule;
        this.messagePipeline = messagePipeline;
    }

    @Async
    public void send(MessageType messageType, String format, EventMetadata<?> eventMetadata) {
        UnaryOperator<String> integrationOperator = eventMetadata.getIntegration();
        if (integrationOperator == null) {
            return;
        }
        if (!this.integrationModule.hasMessenger()) {
            return;
        }
        FEntity sender = eventMetadata.getSender();
        Component componentFormat = this.messagePipeline.builder(sender, FPlayer.UNKNOWN, format).flag(MessageFlag.SENDER_COLOR_OUT, eventMetadata.isSenderColorOut()).flag(MessageFlag.TRANSLATE, false).tagResolvers(eventMetadata.getTagResolvers(FPlayer.UNKNOWN)).build();
        String message = eventMetadata.getMessage();
        TextComponent componentMessage = StringUtils.isEmpty((CharSequence)message) ? Component.empty() : this.messagePipeline.builder(sender, FPlayer.UNKNOWN, message).flag(MessageFlag.SENDER_COLOR_OUT, eventMetadata.isSenderColorOut()).flag(MessageFlag.TRANSLATE, false).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).build();
        PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
        String plainMessage = serializer.serialize((Component)componentMessage);
        String finalMessage = Strings.CS.replace(serializer.serialize(componentFormat), "<message>", plainMessage);
        String finalClearMessage = RegExUtils.replaceAll((CharSequence)finalMessage, (Pattern)this.finalClearMessagePattern, (String)"");
        UnaryOperator interfaceReplaceString = s -> {
            String input = (String)integrationOperator.apply((String)s);
            if (StringUtils.isBlank((CharSequence)input)) {
                return "";
            }
            return StringUtils.replaceEach((String)input, (String[])new String[]{"<player>", "<message>", "<plain_message>", "<final_message>", "<final_clear_message>"}, (String[])new String[]{sender.getName(), message, plainMessage, finalMessage, finalClearMessage});
        };
        String messageName = this.createMessageName(messageType, eventMetadata);
        this.integrationModule.sendMessage(sender, messageName, interfaceReplaceString);
    }

    private String createMessageName(MessageType messageType, EventMetadata<?> eventMetadata) {
        if (messageType != MessageType.CHAT) {
            return messageType.name();
        }
        if (!(eventMetadata instanceof ChatMetadata)) {
            return "UNKNOWN";
        }
        ChatMetadata chatMetadata = (ChatMetadata)eventMetadata;
        return messageType.name() + "_" + chatMetadata.getChatName().toUpperCase();
    }
}

